/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ExternalDataArea {
    private static final String META_AREA = ".metadata";
    private static final String PLUGIN_DATA = ".plugins";
    private static final String PREFERENCES_FILE_NAME = "pref_store.ini";
    private final IPath location;

    public ExternalDataArea(IPath location, ConflictResolution strategy) throws CoreException {
        this.location = location;
        FileUtils.prepareDestination(location.append(META_AREA).toFile(), strategy, (IProgressMonitor)new NullProgressMonitor());
    }

    public IPath getInstanceDataLocation() {
        return this.location;
    }

    public IPath getMetadataLocation() {
        return this.location.append(META_AREA);
    }

    public IPath getPreferenceLocation(String bundleName, boolean create) throws IllegalStateException {
        IPath result = this.getStateLocation(bundleName);
        if (create) {
            result.toFile().mkdirs();
        }
        return result.append(PREFERENCES_FILE_NAME);
    }

    public IPath getStateLocation(String bundleName) {
        return this.getMetadataLocation().append(PLUGIN_DATA).append(bundleName);
    }
}

