/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.rmap.model.BidirectionalTransformer;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.eclipse.equinox.p2.metadata.Version;

public abstract class AbstractConverter
extends AbstractExtension
implements IVersionConverter {
    private static final BidirectionalTransformer[] noTransformers = new BidirectionalTransformer[0];
    private BidirectionalTransformer[] transformers = noTransformers;
    private IVersionFormat versionFormat = this.getDefaultVersionFormat();

    public IVersionFormat getVersionFormat() {
        return this.versionFormat;
    }

    public final void setTransformers(BidirectionalTransformer[] transformers) {
        transformers = transformers == null ? noTransformers : transformers;
    }

    public final void setVersionFormat(IVersionFormat versionFormat) {
        versionFormat = versionFormat == null ? this.getDefaultVersionFormat() : versionFormat;
    }

    protected String createSelectorComponent(Version source) throws CoreException {
        String result = source.toString();
        if (this.transformers.length > 0) {
            boolean matchFound = false;
            BidirectionalTransformer[] bidirectionalTransformerArray = this.transformers;
            int n = this.transformers.length;
            int n2 = 0;
            while (n2 < n) {
                BidirectionalTransformer transformer = bidirectionalTransformerArray[n2];
                String transformed = transformer.transformFrom(result);
                if (transformed != null) {
                    matchFound = true;
                    result = transformed;
                }
                ++n2;
            }
            if (!matchFound) {
                return null;
            }
        }
        return result;
    }

    protected Version createVersionFromSelectorComponent(String source) throws CoreException {
        if (this.transformers.length > 0) {
            boolean matchFound = false;
            BidirectionalTransformer[] bidirectionalTransformerArray = this.transformers;
            int n = this.transformers.length;
            int n2 = 0;
            while (n2 < n) {
                BidirectionalTransformer transformer = bidirectionalTransformerArray[n2];
                String transformed = transformer.transformTo(source);
                if (transformed != null) {
                    matchFound = true;
                    source = transformed;
                }
                ++n2;
            }
            if (!matchFound) {
                return null;
            }
        }
        try {
            return this.versionFormat.parse(source);
        }
        catch (IllegalArgumentException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    protected abstract IVersionFormat getDefaultVersionFormat();
}

