/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.generic.plugin;

import org.eclipse.buckminster.generic.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginClassHandle<T> {
    private static final String ATT_CLASS = "class";
    protected final IConfigurationElement configElement;
    private final Class<T> clazz;
    private T handle;
    private final Plugin plugin;

    protected PluginClassHandle(Plugin plugin, IConfigurationElement configElement, Class<T> clazz, String requiredElement) {
        this.plugin = plugin;
        this.configElement = configElement;
        this.clazz = clazz;
        if (!configElement.getName().equals(requiredElement)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.requiredElement_0_not_correct_expected_1, (Object)configElement.getName(), (Object)requiredElement));
        }
    }

    public synchronized T getHandle() {
        if (this.handle != null) {
            return this.handle;
        }
        try {
            this.handle = this.clazz.cast(this.configElement.createExecutableExtension(ATT_CLASS));
        }
        catch (CoreException e) {
            this.logLoadError(this.configElement, (Exception)((Object)e));
        }
        return this.handle;
    }

    protected void logLoadError(IConfigurationElement configElem, Exception e) {
        String name = configElem.getName();
        String msg = NLS.bind((String)Messages.failed_to_load_extension_point_element_0_in_1, (Object)(name == null ? "[" + Messages.missing_name_attribute + "]" : name), (Object)configElem.getDeclaringExtension().getNamespaceIdentifier());
        ILog log = this.plugin.getLog();
        log.log((IStatus)new Status(4, this.plugin.getBundle().getSymbolicName(), msg));
    }
}

