/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subclipse.internal;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Date;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.subclipse.Messages;
import org.eclipse.buckminster.subclipse.internal.SvnSession;
import org.eclipse.buckminster.subclipse.internal.TypeTranslator;
import org.eclipse.buckminster.subversion.GenericCache;
import org.eclipse.buckminster.subversion.GenericRemoteReader;
import org.eclipse.buckminster.subversion.ISubversionSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnRemoteFileReader
extends GenericRemoteReader<ISVNDirEntry, SVNRevision> {
    public SvnRemoteFileReader(IReaderType readerType, ProviderMatch rInfo, IProgressMonitor monitor) throws CoreException {
        super(readerType, rInfo, monitor);
    }

    public void innerMaterialize(IPath destination, IProgressMonitor monitor) throws CoreException {
        boolean success = false;
        final File destDir = destination.toFile();
        final Object[] resultSlot = new Object[1];
        monitor.beginTask(this.toString(), 12);
        Thread worker = new Thread(){

            public void run() {
                try {
                    SVNUrl svnURL = TypeTranslator.from(SvnRemoteFileReader.this.getSession().getSVNUrl(null));
                    SVNRevision svnRev = (SVNRevision)SvnRemoteFileReader.this.getSession().getRevision();
                    CorePlugin.getLogger().debug("Checking out %s using revision %s", new Object[]{svnURL, svnRev});
                    SvnRemoteFileReader.this.getSession().getClientAdapter().checkout(svnURL, destDir, svnRev, true);
                    resultSlot[0] = Boolean.TRUE;
                }
                catch (Throwable e) {
                    resultSlot[0] = e;
                }
            }
        };
        try {
            try {
                Object result;
                worker.start();
                int workAmount = 0;
                while ((result = resultSlot[0]) == null) {
                    if (monitor.isCanceled()) {
                        worker.interrupt();
                        throw new OperationCanceledException();
                    }
                    Thread.sleep(500L);
                    if (workAmount >= 10) continue;
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                    ++workAmount;
                }
                if (result instanceof Throwable) {
                    throw BuckminsterException.wrap((Throwable)((Throwable)result));
                }
                success = true;
            }
            catch (InterruptedException e) {
                throw BuckminsterException.fromMessage((String)Messages.svn_checkout_timed_out, (Object[])new Object[0]);
            }
        }
        finally {
            if (!success) {
                try {
                    FileUtils.deleteRecursive((File)destDir, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            monitor.done();
        }
    }

    protected void fetchRemoteFile(URI url, SVNRevision revision, OutputStream output, IProgressMonitor monitor) throws Exception {
        int ticksLeft = 3;
        InputStream input = null;
        byte[] buf = new byte[4096];
        ISVNClientAdapter clientAdapter = this.getSession().getClientAdapter();
        input = clientAdapter.getContent(TypeTranslator.from(url), revision, revision);
        int bytesRead = input.read(buf);
        while (bytesRead > 0) {
            output.write(buf, 0, bytesRead);
            bytesRead = input.read(buf);
            if (ticksLeft > 0) {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                --ticksLeft;
                continue;
            }
            MonitorUtils.testCancelStatus((IProgressMonitor)monitor);
        }
    }

    protected ISubversionSession<ISVNDirEntry, SVNRevision> getSession(String repositoryURI, VersionSelector branchOrTag, long revision, Date timestamp, RMContext context) throws CoreException {
        return new SvnSession(repositoryURI, branchOrTag, revision, timestamp, context);
    }

    protected ISVNDirEntry[] getTopEntries(IProgressMonitor monitor) throws CoreException {
        URI url = this.getSession().getSVNUrl(null);
        return this.getSession().innerListFolder(url, monitor);
    }

    protected boolean remoteFileExists(URI url, SVNRevision revision, IProgressMonitor monitor) throws CoreException {
        try {
            ISVNClientAdapter clientAdapter = this.getSession().getClientAdapter();
            return clientAdapter.getDirEntry(TypeTranslator.from(url), revision) != null;
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    protected String storeInCache(String fileName) throws CoreException {
        SvnSession svnSession = this.getSession();
        return GenericCache.cacheKey((URI)svnSession.getSVNUrl(fileName), (Object)svnSession.getRevision());
    }

    private SvnSession getSession() {
        return (SvnSession)this.session;
    }
}

