/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.actor.IPerformManager;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.core.helpers.FilterUtils;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeActionJob
extends WorkspaceJob {
    private final List<Attribute> attributes;
    private final File propertiesFile;
    private boolean forced;

    public InvokeActionJob(String name, List<Attribute> attributes, File propertiesFile, boolean forced) {
        super(name);
        this.setPriority(30);
        this.setUser(true);
        this.setSystem(false);
        this.attributes = attributes;
        this.propertiesFile = propertiesFile;
        this.forced = forced;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        IPerformManager pm = CorePlugin.getPerformManager();
        HashMap props = null;
        if (this.propertiesFile != null) {
            BufferedInputStream input = null;
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(this.propertiesFile));
                    props = new HashMap(new BMProperties((InputStream)input));
                    for (Map.Entry entry : props.entrySet()) {
                        if (!"*".equals(entry.getValue())) continue;
                        entry.setValue(FilterUtils.MATCH_ALL_OBJ);
                    }
                }
                catch (IOException iOException) {
                    IStatus iStatus = BuckminsterException.wrap((Throwable)iOException).getStatus();
                    IOUtils.close(input);
                    return iStatus;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(input);
                throw throwable;
            }
            IOUtils.close((Closeable)input);
        }
        try {
            return pm.perform(this.attributes, props, this.forced, false, monitor).getStatus();
        }
        catch (Throwable e) {
            final IStatus iStatus = BuckminsterException.wrap((Throwable)e).getStatus();
            CorePlugin.logWarningsAndErrors((IStatus)iStatus);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError(null, (String)Messages.action_error, null, (IStatus)iStatus);
                }
            });
            return Status.OK_STATUS;
        }
    }
}

