/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.cspec;

import java.util.List;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.ctype.AbstractComponentType;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.VersionDesignator;
import org.eclipse.buckminster.ui.editor.VersionDesignatorEvent;
import org.eclipse.buckminster.ui.editor.VersionDesignatorListener;
import org.eclipse.buckminster.ui.general.editor.IValidator;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.simple.IWidgetin;
import org.eclipse.buckminster.ui.general.editor.simple.SimpleTable;
import org.eclipse.buckminster.ui.general.editor.simple.WidgetWrapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependenciesTable
extends SimpleTable<ComponentRequestBuilder> {
    private CSpecBuilder cspecBuilder;
    private VersionDesignatorValidator versionDesignatorValidator;
    private FilterValidator filterValidator;

    public DependenciesTable(List<ComponentRequestBuilder> data, CSpecBuilder cspecBuilder, boolean readOnly) {
        super(data, readOnly);
        this.cspecBuilder = cspecBuilder;
        this.filterValidator = new FilterValidator();
    }

    @Override
    public ComponentRequestBuilder createRowClass() {
        return this.cspecBuilder.createDependencyBuilder();
    }

    @Override
    public IWidgetin[] fillGrid(Composite parent, Object[] fieldValues) {
        ((GridLayout)parent.getLayout()).numColumns = 3;
        IWidgetin[] widgetins = new IWidgetin[this.getColumns()];
        UiUtils.createGridLabel(parent, String.valueOf(this.getColumnHeaders()[0]) + ":", 1, 0, 0);
        widgetins[0] = this.getWidgetin(parent, 0, fieldValues[0]);
        UiUtils.createGridLabel(parent, String.valueOf(this.getColumnHeaders()[1]) + ":", 1, 0, 0);
        widgetins[1] = this.getWidgetin(parent, 1, fieldValues[1]);
        new Label(parent, 0);
        widgetins[2] = this.getWidgetin(parent, 2, fieldValues[2]);
        UiUtils.createGridLabel(parent, String.valueOf(this.getColumnHeaders()[3]) + ":", 1, 0, 0);
        widgetins[3] = this.getWidgetin(parent, 3, fieldValues[3]);
        return widgetins;
    }

    @Override
    public String[] getColumnHeaders() {
        return new String[]{Messages.name, Messages.component_type, Messages.version_designator, Messages.filter};
    }

    @Override
    public int[] getColumnWeights() {
        return new int[]{40, 20, 20, 20};
    }

    @Override
    public IValidator getFieldValidator(int idx) {
        switch (idx) {
            case 0: {
                return SimpleTable.createNotEmptyStringValidator(Messages.dependency_name_cannot_be_empty);
            }
            case 2: {
                return this.versionDesignatorValidator;
            }
            case 3: {
                return this.filterValidator;
            }
        }
        return SimpleTable.getEmptyValidator();
    }

    @Override
    public IWidgetin getWidgetin(Composite parent, int idx, Object value) {
        switch (idx) {
            case 0: {
                return this.getName(parent, idx, value);
            }
            case 1: {
                return this.getComboWidgetin(parent, idx, value, AbstractComponentType.getComponentTypeIDs((boolean)true), 8);
            }
            case 2: {
                VersionDesignator designator = this.getVersionDesignator(parent, idx, value);
                this.versionDesignatorValidator = new VersionDesignatorValidator(designator);
                return designator;
            }
            case 3: {
                return this.getFilter(parent, idx, value);
            }
        }
        return this.getTextWidgetin(parent, idx, value);
    }

    @Override
    public Object[] toRowArray(ComponentRequestBuilder t) {
        Object[] array = new Object[this.getColumns()];
        array[0] = t.getName();
        array[1] = t.getComponentTypeID();
        array[2] = VersionHelper.getHumanReadable((VersionRange)t.getVersionRange());
        array[3] = t.getFilter();
        return array;
    }

    @Override
    public void updateRowClass(ComponentRequestBuilder builder, Object[] args) throws ValidatorException {
        builder.setName(TextUtils.notEmptyString((String)((String)args[0])));
        builder.setComponentTypeID(TextUtils.notEmptyString((String)((String)args[1])));
        builder.setVersionRange((VersionRange)args[2]);
        builder.setFilter((Filter)args[3]);
    }

    private IWidgetin getFilter(Composite parent, final int idx, Object value) {
        final Text text = UiUtils.createGridText(parent, 2, 0, this.isReadOnly(), 0);
        final WidgetWrapper widgetin = new WidgetWrapper((Widget)text);
        String stringValue = TextUtils.notNullString((Object)value);
        text.setText(stringValue);
        text.setData(value);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filterStr = TextUtils.notEmptyTrimmedString((String)text.getText());
                widgetin.setData(DependenciesTable.this.filterValidator.createFilter(filterStr));
                DependenciesTable.this.validateFieldInFieldListener(widgetin, DependenciesTable.this.getFieldValidator(idx), widgetin.getData());
            }
        });
        return widgetin;
    }

    private IWidgetin getName(Composite parent, final int idx, Object value) {
        final Text text = UiUtils.createGridText(parent, 2, 0, this.isReadOnly(), 0);
        final WidgetWrapper widgetin = new WidgetWrapper((Widget)text);
        String stringValue = value == null ? "" : value.toString();
        text.setText(stringValue);
        text.setData((Object)stringValue);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                widgetin.setData(text.getText());
                DependenciesTable.this.validateFieldInFieldListener(widgetin, DependenciesTable.this.getFieldValidator(idx), text.getText());
            }
        });
        return widgetin;
    }

    private VersionDesignator getVersionDesignator(Composite parent, final int idx, Object value) {
        final VersionDesignator designator = new VersionDesignator(parent, this.isReadOnly());
        designator.refreshValues(new VersionRange((String)value));
        designator.setData(value);
        designator.addVersionDesignatorListener(new VersionDesignatorListener(){

            public void modifyVersionDesignator(VersionDesignatorEvent e) {
                try {
                    VersionRange designatorValue = designator.getDirectVersionDesignator();
                    designator.setData(designatorValue);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                DependenciesTable.this.validateFieldInFieldListener(designator, DependenciesTable.this.getFieldValidator(idx), null);
            }
        });
        return designator;
    }

    class FilterValidator
    implements IValidator {
        private ValidatorException lastFilterException;

        FilterValidator() {
        }

        public Filter createFilter(String value) {
            value = TextUtils.notEmptyString((String)value);
            Filter filter = null;
            this.lastFilterException = null;
            try {
                filter = value == null ? null : FilterFactory.newInstance((String)value);
            }
            catch (InvalidSyntaxException e) {
                this.lastFilterException = new ValidatorException(e.getMessage());
            }
            return filter;
        }

        public void validate(Object ... arg) throws ValidatorException {
            if (this.lastFilterException != null) {
                throw this.lastFilterException;
            }
        }
    }

    class VersionDesignatorValidator
    implements IValidator {
        VersionDesignator designator;

        public VersionDesignatorValidator(VersionDesignator designator) {
            this.designator = designator;
        }

        public void validate(Object ... arg) throws ValidatorException {
            try {
                this.designator.getDirectVersionDesignator();
            }
            catch (CoreException e) {
                throw new ValidatorException(e.getMessage());
            }
        }
    }
}

