/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.ArrayUtils;
import org.eclipse.buckminster.core.helpers.LocalizedException;
import org.eclipse.buckminster.core.helpers.NullOutputStream;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileUtils {
    public static final String FILE_SEP = System.getProperty("file.separator");
    public static final String PATH_SEP = System.getProperty("path.separator");
    public static final boolean CASE_INSENSITIVE_FS = new File("a").equals(new File("A"));
    private static final Pattern[] defaultExcludes;
    private static final Object THREADLOCK;
    private static HashSet<File> foldersToRemove;

    static {
        THREADLOCK = new Object();
        ArrayList<Pattern> bld = new ArrayList<Pattern>();
        FileUtils.addPattern(bld, ".*/[^/]*~$");
        FileUtils.addPattern(bld, ".*/#[^/]*#$");
        FileUtils.addPattern(bld, ".*/\\.#[^/]*$");
        FileUtils.addPattern(bld, ".*/%_[^/]*$");
        FileUtils.addPattern(bld, ".*/CVS$");
        FileUtils.addPattern(bld, ".*/CVS/.*");
        FileUtils.addPattern(bld, ".*/\\.cvsignore$");
        FileUtils.addPattern(bld, ".*/SCCS$");
        FileUtils.addPattern(bld, ".*/SCCS/.*");
        FileUtils.addPattern(bld, ".*/vssver\\.scc$");
        FileUtils.addPattern(bld, ".*/\\.svn$");
        FileUtils.addPattern(bld, ".*/\\.svn/.*");
        FileUtils.addPattern(bld, ".*/\\.DS_Store$");
        defaultExcludes = bld.toArray(new Pattern[bld.size()]);
    }

    public static void appendRelativeFiles(File directory, File relPath, Map<String, Long> fileNames) {
        File fileOrDir;
        String path = relPath.getPath();
        File file = fileOrDir = relPath.isAbsolute() ? relPath : new File(directory, path);
        if (fileOrDir.isDirectory()) {
            StringBuilder builder = new StringBuilder();
            builder.append(path);
            FileUtils.appendRelativeFiles(fileOrDir, fileNames, builder);
        } else {
            long ts = fileOrDir.lastModified();
            if (ts != 0L) {
                fileNames.put(path, new Long(ts));
            }
        }
    }

    public static void appendRelativeFiles(File directory, Map<String, Long> fileNames) {
        FileUtils.appendRelativeFiles(directory, fileNames, new StringBuilder());
    }

    public static byte[] calculateDigest(File f, String algorithm, IProgressMonitor monitor) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        DigestOutputStream dos = new DigestOutputStream(NullOutputStream.INSTANCE, md);
        if (f.isFile()) {
            FileInputStream fis = new FileInputStream(f);
            try {
                FileUtils.copyFile(fis, dos, monitor);
            }
            finally {
                IOUtils.close((Closeable)fis);
            }
        } else {
            FileUtils.deepCalculateDigest(f, dos, f.getCanonicalPath().length() + 1, monitor);
        }
        dos.close();
        return md.digest();
    }

    public static void checkCopyConditions(File sourceFile, File destination, ConflictResolution strategy, IProgressMonitor monitor) throws CoreException {
        File tmp = destination;
        while (tmp != null) {
            if (tmp.equals(sourceFile)) {
                throw new CopyOntoSelfException(sourceFile, destination);
            }
            tmp = tmp.getParentFile();
        }
        FileUtils.prepareDestination(destination, strategy, monitor);
    }

    public static boolean compareContents(InputStream a, InputStream b) throws IOException {
        int countA;
        byte[] bufA = new byte[1024];
        byte[] bufB = new byte[1024];
        while ((countA = a.read(bufA)) > 0) {
            if (b.read(bufB) != countA) {
                return false;
            }
            if (ArrayUtils.equals(bufA, bufB, 0, countA)) continue;
            return false;
        }
        return b.read(bufB) == countA;
    }

    public static long copyFile(File source, File destDir, String destName, IProgressMonitor monitor) throws CoreException {
        long l;
        FileInputStream input = null;
        try {
            input = new FileInputStream(source);
            l = FileUtils.copyFile((InputStream)input, destDir, destName, monitor);
        }
        catch (IOException e) {
            try {
                throw BuckminsterException.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(input);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)input);
        return l;
    }

    public static long copyFile(InputStream input, File destDir, String destName, IProgressMonitor monitor) throws CoreException {
        OutputStream output = null;
        MonitorUtils.begin((IProgressMonitor)monitor, (int)1000);
        try {
            if (destDir != null) {
                File destFile = new File(destDir, destName);
                if ((destDir = destFile.getParentFile()) != null && !destDir.exists()) {
                    FileUtils.createDirectory(destDir, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                } else {
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)100);
                }
                output = new FileOutputStream(destFile);
                MonitorUtils.worked((IProgressMonitor)monitor, (int)100);
            } else {
                output = NullOutputStream.INSTANCE;
            }
            long l = FileUtils.copyFile(input, output, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)700));
            return l;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            IOUtils.close((Closeable)output);
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    public static long copyFile(InputStream input, OutputStream output, byte[] buf, IProgressMonitor monitor) throws IOException {
        long total = 0L;
        MonitorUtils.begin((IProgressMonitor)monitor, (int)-1);
        try {
            int count;
            while ((count = input.read(buf)) > 0) {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                output.write(buf, 0, count);
                total += (long)count;
            }
            long l = total;
            return l;
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    public static long copyFile(InputStream input, OutputStream output, IProgressMonitor monitor) throws IOException {
        if (input instanceof FileInputStream && output instanceof FileOutputStream) {
            FileChannel in = ((FileInputStream)input).getChannel();
            FileChannel out = ((FileOutputStream)output).getChannel();
            long size = in.size();
            if (in.transferTo(0L, size, out) != size) {
                throw new IOException("Incomplete copy!");
            }
            MonitorUtils.complete((IProgressMonitor)monitor);
            return size;
        }
        return FileUtils.copyFile(input, output, new byte[8192], monitor);
    }

    public static synchronized void createDirectory(File file, IProgressMonitor monitor) throws MkdirException {
        MonitorUtils.begin((IProgressMonitor)monitor, (int)1);
        try {
            try {
                if (!file.mkdirs() && !file.isDirectory()) {
                    throw new MkdirException(file);
                }
                MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
            }
            catch (SecurityException e) {
                throw new MkdirException(file, e);
            }
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    public static void createFolder(IContainer container) throws CoreException {
        NullProgressMonitor nullMonitor = new NullProgressMonitor();
        if (container instanceof IFolder) {
            IFolder folder = (IFolder)container;
            FileUtils.createFolder(folder.getParent());
            folder.refreshLocal(0, (IProgressMonitor)nullMonitor);
            if (!folder.exists()) {
                folder.create(false, true, (IProgressMonitor)nullMonitor);
            }
        }
    }

    public static synchronized void createTempFolder(File tmpDir) throws MkdirException {
        if (!tmpDir.mkdirs()) {
            throw new MkdirException(tmpDir);
        }
        if (foldersToRemove == null) {
            foldersToRemove = new HashSet();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    HashSet folders = new HashSet(foldersToRemove);
                    foldersToRemove = null;
                    for (File folder : folders) {
                        try {
                            FileUtils.deleteRecursive(folder, null);
                        }
                        catch (Exception e) {
                            System.err.println("Failed to remove directory " + folder + " :" + e.toString());
                        }
                    }
                }
            });
        }
        foldersToRemove.add(tmpDir);
    }

    public static synchronized File createTempFolder(String prefix, String suffix) throws CoreException {
        File tmpFile;
        try {
            tmpFile = File.createTempFile(prefix, suffix);
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        if (!tmpFile.delete()) {
            throw new MkdirException(tmpFile);
        }
        FileUtils.createTempFolder(tmpFile);
        return tmpFile;
    }

    public static void deepCopy(File sourceDirectory, File destinationDirectory, ConflictResolution strategy, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.begin((IProgressMonitor)monitor, (int)1000);
        try {
            FileUtils.checkCopyConditions(sourceDirectory, destinationDirectory, strategy, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            FileUtils.deepCopyUnchecked(sourceDirectory, destinationDirectory, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)900));
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    public static void deepCopyUnchecked(File source, File dest, IProgressMonitor monitor) throws CoreException {
        FileUtils.deepCopyUnchecked(source, dest, null, defaultExcludes, monitor);
    }

    public static void deepCopyUnchecked(File source, File dest, Pattern[] includes, Pattern[] excludes, IProgressMonitor monitor) throws CoreException {
        File[] files;
        String sourceStr;
        block15: {
            sourceStr = source.toString().replace('\\', '/');
            boolean isDir = source.isDirectory();
            if (isDir && sourceStr.charAt(sourceStr.length() - 1) != '/') {
                sourceStr = String.valueOf(sourceStr) + '/';
            }
            if (!FileUtils.isMatch(sourceStr, includes, true) || FileUtils.isMatch(sourceStr, excludes, false)) {
                MonitorUtils.complete((IProgressMonitor)monitor);
                return;
            }
            files = source.listFiles();
            if (files == null || files.length == 0) {
                try {
                    if (isDir) {
                        MonitorUtils.complete((IProgressMonitor)monitor);
                        break block15;
                    }
                    if (source.isFile()) {
                        FileUtils.copyFile(source, dest, source.getName(), monitor);
                        break block15;
                    }
                    throw new FileNotFoundException(source.getAbsolutePath());
                }
                catch (IOException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
        }
        MonitorUtils.begin((IProgressMonitor)monitor, (int)(10 + files.length * 100));
        try {
            FileUtils.createDirectory(dest, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                IProgressMonitor subMonitor = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100);
                if (file.isFile()) {
                    sourceStr = source.toString().replace('\\', '/');
                    if (FileUtils.isMatch(sourceStr, includes, true) && !FileUtils.isMatch(sourceStr, excludes, false)) {
                        FileUtils.copyFile(file, dest, file.getName(), subMonitor);
                    } else {
                        MonitorUtils.complete((IProgressMonitor)subMonitor);
                    }
                } else {
                    FileUtils.deepCopyUnchecked(file, new File(dest, file.getName()), includes, excludes, subMonitor);
                }
                ++n2;
            }
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    public static void deleteRecursive(File file, IProgressMonitor monitor) throws DeleteException {
        MonitorUtils.begin((IProgressMonitor)monitor, (int)1000);
        try {
            if (file == null) {
                return;
            }
            try {
                int count;
                File[] list = file.listFiles();
                int n = count = list == null ? 0 : list.length;
                if (count > 0) {
                    IProgressMonitor subMon = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)900);
                    MonitorUtils.begin((IProgressMonitor)subMon, (int)(count * 100));
                    try {
                        if (foldersToRemove != null) {
                            foldersToRemove.remove(file);
                        }
                        while (--count >= 0) {
                            FileUtils.deleteRecursive(list[count], MonitorUtils.subMonitor((IProgressMonitor)subMon, (int)100));
                        }
                    }
                    finally {
                        MonitorUtils.done((IProgressMonitor)subMon);
                    }
                } else {
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)900);
                }
                if (!file.delete() && file.exists()) {
                    throw new DeleteException(file);
                }
                MonitorUtils.worked((IProgressMonitor)monitor, (int)100);
            }
            catch (SecurityException e) {
                throw new DeleteException(file, e);
            }
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    public static File findPath(Bundle bundle, String path) throws CoreException {
        try {
            return path == null ? null : new File(FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path(path), null)).toURI());
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public static File findPath(Plugin plugin, String path) throws CoreException {
        return FileUtils.findPath(plugin.getBundle(), path);
    }

    public static File findPath(String pluginId, String path) throws CoreException {
        return FileUtils.findPath(Platform.getBundle((String)pluginId), path);
    }

    public static long getCRC(InputStream input) throws IOException {
        int count;
        CRC32 crc32 = new CRC32();
        byte[] copyBuffer = new byte[8192];
        while ((count = input.read(copyBuffer)) > 0) {
            crc32.update(copyBuffer, 0, count);
        }
        return crc32.getValue();
    }

    public static long getCRCAndCopy(InputStream input, OutputStream output) throws IOException {
        int count;
        CRC32 crc32 = new CRC32();
        byte[] copyBuffer = new byte[8192];
        while ((count = input.read(copyBuffer)) > 0) {
            output.write(copyBuffer, 0, count);
            crc32.update(copyBuffer, 0, count);
        }
        return crc32.getValue();
    }

    public static File getFile(URL url) {
        if (url == null) {
            return null;
        }
        String proto = url.getProtocol();
        if (proto == null) {
            proto = "file";
        } else {
            try {
                URL newUrl = FileLocator.resolve((URL)url);
                if (newUrl != url) {
                    proto = newUrl.getProtocol();
                    url = newUrl;
                }
            }
            catch (IOException newUrl) {
                // empty catch block
            }
        }
        if ("file".equalsIgnoreCase(proto)) {
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException e) {
                String path = url.getPath();
                if (path.indexOf(32) >= 0) {
                    return new File(path);
                }
                CorePlugin.getLogger().warning((Throwable)e, e.getMessage(), new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static IPath getFileAsPath(URL url) {
        File file = FileUtils.getFile(url);
        return file == null ? null : new Path(file.toString());
    }

    public static long getFirstModified(File fileOrDir, int expectedFileCount, int[] realFileCount) {
        int count;
        if (fileOrDir.isFile() && expectedFileCount <= 1) {
            realFileCount[0] = 1;
            return fileOrDir.lastModified();
        }
        long[] timestampHolder = new long[]{Long.MAX_VALUE};
        realFileCount[0] = count = FileUtils.countFilesAndGetOldest(fileOrDir, 0, timestampHolder);
        if (count == 0 || expectedFileCount < 0 || timestampHolder[0] == Long.MAX_VALUE) {
            return 0L;
        }
        return timestampHolder[0];
    }

    public static long getLastModified(File fileOrDir, long threshold, int[] realFileCount) {
        int count = 0;
        long lastModTime = 0L;
        File[] files = fileOrDir.listFiles();
        if (files == null) {
            if (fileOrDir.isFile()) {
                lastModTime = fileOrDir.lastModified();
                count = 1;
            }
        } else {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File p = fileArray[n2];
                int[] dirFileCount = new int[1];
                long modTime = FileUtils.getLastModified(p, threshold, dirFileCount);
                count += dirFileCount[0];
                if (modTime > lastModTime) {
                    lastModTime = modTime;
                    if (modTime > threshold) break;
                }
                ++n2;
            }
        }
        realFileCount[0] = count;
        return lastModTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mkdirs(File directory) throws CoreException {
        Object object = THREADLOCK;
        synchronized (object) {
            if (directory == null || directory.exists() && !directory.isDirectory()) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Unable_to_create_directory_0_Not_a_directory, (Object)(directory != null ? directory : "(null)")), (Object[])new Object[0]);
            }
            if (!directory.exists() && !directory.mkdirs()) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Unable_to_create_directory_0, (Object)directory), (Object[])new Object[0]);
            }
        }
    }

    public static boolean pathEquals(IPath a, IPath b) {
        return a == null || b == null ? a == b : a.toFile().equals(b.toFile());
    }

    public static IPath pathForLocation(IPath location) {
        if (Platform.getLocation().equals((Object)location)) {
            return Path.ROOT;
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            IPath projectLocation = project.getLocation();
            if (projectLocation != null && projectLocation.isPrefixOf(location)) {
                int segmentsToRemove = projectLocation.segmentCount();
                return project.getFullPath().append(location.removeFirstSegments(segmentsToRemove));
            }
            ++i;
        }
        return null;
    }

    public static void prepareDestination(File destination, ConflictResolution strategy, IProgressMonitor monitor) throws CoreException {
        block14: {
            MonitorUtils.begin((IProgressMonitor)monitor, (int)200);
            try {
                File[] list = destination.listFiles();
                MonitorUtils.worked((IProgressMonitor)monitor, (int)30);
                if (list == null) {
                    if (destination.isFile()) {
                        if (strategy == ConflictResolution.FAIL) {
                            throw new DestinationNotEmptyException(destination);
                        }
                        if (strategy != ConflictResolution.KEEP && !destination.delete()) {
                            throw new DeleteException(destination);
                        }
                        MonitorUtils.worked((IProgressMonitor)monitor, (int)85);
                    }
                    FileUtils.createDirectory(destination, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)85));
                    break block14;
                }
                int numFiles = list.length;
                if (numFiles > 0) {
                    IProgressMonitor subMonitor = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)170);
                    MonitorUtils.begin((IProgressMonitor)subMonitor, (int)(numFiles * 100));
                    try {
                        if (strategy == ConflictResolution.FAIL) {
                            throw new DestinationNotEmptyException(destination);
                        }
                        if (strategy == ConflictResolution.REPLACE) {
                            File[] fileArray = list;
                            int n = list.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File file = fileArray[n2];
                                FileUtils.deleteRecursive(file, MonitorUtils.subMonitor((IProgressMonitor)subMonitor, (int)100));
                                ++n2;
                            }
                        }
                        break block14;
                    }
                    finally {
                        MonitorUtils.done((IProgressMonitor)subMonitor);
                    }
                }
                MonitorUtils.worked((IProgressMonitor)monitor, (int)170);
            }
            finally {
                MonitorUtils.done((IProgressMonitor)monitor);
            }
        }
    }

    public static void substituteParameters(InputStream input, OutputStream output, char delim, Map<String, String> substitutions) throws IOException {
        int c;
        BufferedInputStream bufferedInput = new BufferedInputStream(input);
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);
        block0: while ((c = bufferedInput.read()) >= 0) {
            String paramName;
            String param;
            if (c != delim) {
                bufferedOutput.write((byte)c);
                continue;
            }
            bufferedInput.mark(Integer.MAX_VALUE);
            c = bufferedInput.read();
            if (c == delim) {
                bufferedOutput.write(delim);
                continue;
            }
            StringBuilder nameBuilder = new StringBuilder();
            nameBuilder.append((char)c);
            while ((c = bufferedInput.read()) >= 0) {
                if (c == delim) break;
                if (Character.isJavaIdentifierPart((char)c)) {
                    nameBuilder.append((char)c);
                    continue;
                }
                bufferedOutput.write(delim);
                bufferedInput.reset();
                continue block0;
            }
            if ((param = substitutions.get(paramName = nameBuilder.toString())) == null) continue;
            bufferedOutput.write(param.getBytes());
        }
        bufferedOutput.flush();
    }

    public static void unzip(InputStream inputs, String sourceRelPath, File dest, ConflictResolution strategy, IProgressMonitor monitor) throws CoreException {
        ZipInputStream input = null;
        MonitorUtils.begin((IProgressMonitor)monitor, (int)600);
        if (dest != null) {
            FileUtils.prepareDestination(dest, strategy, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
        }
        try {
            try {
                ZipEntry entry;
                int ticksLeft = 500;
                input = new ZipInputStream(inputs);
                while ((entry = input.getNextEntry()) != null) {
                    IProgressMonitor subMonitor;
                    String name = entry.getName();
                    if (sourceRelPath != null && (!name.startsWith(sourceRelPath) || (name = name.substring(sourceRelPath.length() + 1)).length() == 0)) continue;
                    if (ticksLeft > 0) {
                        subMonitor = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10);
                        ticksLeft -= 10;
                    } else {
                        subMonitor = null;
                    }
                    if (entry.isDirectory()) {
                        if (dest == null) continue;
                        FileUtils.createDirectory(new File(dest, name), subMonitor);
                        continue;
                    }
                    FileUtils.copyFile((InputStream)input, dest, name, subMonitor);
                }
                if (ticksLeft > 0) {
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)ticksLeft);
                }
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    public static void unzip(URL source, IConnectContext cctx, String sourceRelPath, File dest, ConflictResolution strategy, IProgressMonitor monitor) throws CoreException {
        InputStream input = null;
        try {
            try {
                input = DownloadManager.read((URL)source, (IConnectContext)cctx);
                FileUtils.unzip(input, sourceRelPath, dest, strategy, monitor);
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close((Closeable)input);
    }

    private static void addPattern(ArrayList<Pattern> bld, String expr) {
        bld.add(Pattern.compile(expr));
    }

    private static void appendRelativeFiles(File directory, Map<String, Long> fileNames, StringBuilder path) {
        File[] files;
        int pathLen = path.length();
        if (pathLen > 0) {
            path.append(FILE_SEP);
            pathLen = path.length();
        }
        if ((files = directory.listFiles()) == null) {
            return;
        }
        int idx = files.length;
        while (--idx >= 0) {
            File file = files[idx];
            String sourceStr = file.toString().replace('\\', '/');
            path.append(file.getName());
            if (file.isDirectory()) {
                if (!FileUtils.isMatch(String.valueOf(sourceStr) + '/', defaultExcludes, false)) {
                    FileUtils.appendRelativeFiles(file, fileNames, path);
                }
            } else if (!FileUtils.isMatch(sourceStr, defaultExcludes, false)) {
                fileNames.put(path.toString(), new Long(file.lastModified()));
            }
            path.setLength(pathLen);
        }
    }

    private static int countFilesAndGetOldest(File fileOrDir, int count, long[] timestampHolder) {
        File[] files = fileOrDir.listFiles();
        if (files == null) {
            if (fileOrDir.isFile()) {
                long timestamp = fileOrDir.lastModified();
                if (timestamp < timestampHolder[0]) {
                    timestampHolder[0] = timestamp;
                }
                ++count;
            }
        } else {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                count = FileUtils.countFilesAndGetOldest(file, count, timestampHolder);
                ++n2;
            }
        }
        return count;
    }

    private static void deepCalculateDigest(File from, OutputStream os, int rootOffset, IProgressMonitor monitor) throws IOException {
        Object[] names = from.listFiles();
        MonitorUtils.begin((IProgressMonitor)monitor, (int)(names.length * 100));
        try {
            Arrays.sort(names);
            int i = 0;
            while (i < names.length) {
                Object p = names[i];
                IProgressMonitor subMonitor = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100);
                os.write(((File)p).getName().getBytes());
                if (((File)p).isDirectory()) {
                    os.write(1);
                    FileUtils.deepCalculateDigest((File)p, os, rootOffset, subMonitor);
                } else {
                    FileInputStream fis = new FileInputStream((File)p);
                    FileUtils.copyFile(fis, os, subMonitor);
                    fis.close();
                }
                ++i;
            }
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    private static boolean isMatch(String fileStr, Pattern[] patterns, boolean whenEmpty) {
        int idx;
        if (patterns != null && (idx = patterns.length) > 0) {
            while (--idx >= 0) {
                if (!patterns[idx].matcher(fileStr).matches()) continue;
                return true;
            }
            return false;
        }
        return whenEmpty;
    }

    public static class CopyOntoSelfException
    extends LocalizedException {
        private static final long serialVersionUID = 379621474603864267L;

        public CopyOntoSelfException(File source, File destination) {
            super(NLS.bind((String)Messages.Cannot_copy_0_to_1_since_destination_equal_or_contained_in_source, (Object)source, (Object)destination), new Object[0]);
        }
    }

    public static class DeleteException
    extends LocalizedException {
        private static final long serialVersionUID = -8216112755038789300L;

        public DeleteException(File file) {
            this(file, null);
        }

        public DeleteException(File file, Throwable e) {
            super(e, NLS.bind((String)Messages.Unable_to_delete_0, (Object)file), new Object[0]);
        }
    }

    public static class DestinationNotEmptyException
    extends LocalizedException {
        private static final long serialVersionUID = -4126568695654461634L;

        public DestinationNotEmptyException(File destination) {
            super(NLS.bind((String)Messages.Unable_to_use_0_destination_for_copy_not_empty, (Object)destination), new Object[0]);
        }
    }

    public static class MkdirException
    extends LocalizedException {
        private static final long serialVersionUID = -1919074286465177750L;

        public MkdirException(File directory) {
            this(directory, null);
        }

        public MkdirException(File directory, Throwable e) {
            super(e, NLS.bind((String)Messages.Unable_to_create_directory_0, (Object)directory), new Object[0]);
        }
    }
}

