/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.actor.IPerformManager;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.materializer.IMaterializer;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.ModelCache;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.GeneratorNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.service.datalocation.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMaterializer
extends AbstractExtension
implements IMaterializer {
    public static String[] getMaterializerIDs(boolean includeEmptyEntry) {
        IConfigurationElement[] elems = AbstractMaterializer.getElements();
        int idx = elems.length;
        ArrayList<String> names = new ArrayList<String>(idx + 1);
        if (includeEmptyEntry) {
            names.add("");
        }
        while (--idx >= 0) {
            names.add(elems[idx].getAttribute("id"));
        }
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }

    public static void performInstallActions(BillOfMaterials bom, MaterializationContext context, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, bom.uniqueNodeCount() * 100);
        try {
            Resolution resolution = bom.getResolution();
            MaterializationSpec mspec = context.getMaterializationSpec();
            IMaterializer materializer = mspec.getMaterializer(resolution);
            LinkedHashSet<Resolution> perused = new LinkedHashSet<Resolution>();
            materializer.installRecursive(bom, context, new HashSet<String>(), perused, monitor);
            IStatus status = context.getStatus();
            if (status.getSeverity() == 4) {
                return;
            }
            LinkedHashSet<String> readerTypes = new LinkedHashSet<String>();
            for (Resolution res : perused) {
                if (mspec.isExcluded(res)) continue;
                readerTypes.add(mspec.getMaterializer(res).getMaterializationReaderType(res).getId());
            }
            CorePlugin plugin = CorePlugin.getDefault();
            for (String readerTypeId : readerTypes) {
                IReaderType readerType = plugin.getReaderType(readerTypeId);
                readerType.postMaterialization(context, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private static IConfigurationElement[] getElements() {
        IExtensionRegistry exReg = Platform.getExtensionRegistry();
        return exReg.getConfigurationElementsFor("org.eclipse.buckminster.core.materializers");
    }

    @Override
    public boolean canWorkInParallel() {
        return true;
    }

    @Override
    public IPath getDefaultInstallRoot(MaterializationContext context, Resolution resolution) throws CoreException {
        File userDir;
        Location userLocation;
        IPath rootDir = Path.fromOSString((String)this.getMaterializerRootDir());
        if (rootDir.isAbsolute()) {
            return rootDir;
        }
        if ("win32".equals(Platform.getOS())) {
            File userDir2 = null;
            String appDataEnv = System.getenv("APPDATA");
            if (appDataEnv != null) {
                userDir2 = new File(String.valueOf(appDataEnv) + "\\buckminster");
                return Path.fromOSString((String)new File(userDir2, rootDir.toOSString()).toString());
            }
        }
        if ((userLocation = Platform.getUserLocation()) != null && (userDir = FileUtils.getFile(userLocation.getURL())) != null) {
            userDir = "win32".equals(Platform.getOS()) ? new File(userDir, "Application Data\\buckminster") : new File(userDir, "buckminster");
            return Path.fromOSString((String)new File(userDir, rootDir.toOSString()).toString());
        }
        throw BuckminsterException.fromMessage((String)Messages.Unable_to_determine_users_home_directory, (Object[])new Object[0]);
    }

    @Override
    public IReaderType getMaterializationReaderType(Resolution resolution) throws CoreException {
        return resolution.getProvider().getReaderType();
    }

    public abstract String getMaterializerRootDir() throws CoreException;

    @Override
    public void installRecursive(BOMNode node, MaterializationContext context, Set<String> generated, Set<Resolution> perused, IProgressMonitor monitor) throws CoreException {
        if (node instanceof GeneratorNode) {
            GeneratorNode generatorNode = (GeneratorNode)node;
            String generates = generatorNode.getGeneratesId().toString();
            if (!generated.contains(generates) && this.generateResolution(generatorNode, context, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100))) {
                generated.add(generates);
            }
        } else {
            Resolution resolution = node.getResolution();
            if (resolution == null || perused.contains(resolution)) {
                return;
            }
            perused.add(resolution);
            for (BOMNode child : node.getChildren()) {
                this.delegateAndInstallRecursive(child, context, generated, perused, monitor);
            }
            if (!context.getMaterializationSpec().isExcluded(resolution)) {
                resolution.store(StorageManager.getDefault());
                this.performInstallAction(resolution, context, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            }
        }
    }

    @Override
    public void performInstallAction(Resolution resolution, MaterializationContext context, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
    }

    private void delegateAndInstallRecursive(BOMNode node, MaterializationContext context, Set<String> generated, Set<Resolution> perused, IProgressMonitor monitor) throws CoreException {
        String materializerId;
        Resolution res = node.getResolution();
        if (res == null) {
            return;
        }
        IMaterializer materializer = node instanceof GeneratorNode ? this : ((materializerId = context.getMaterializationSpec().getMaterializerID(res)).equals(this.getId()) ? this : CorePlugin.getDefault().getMaterializer(materializerId));
        materializer.installRecursive(node, context, generated, perused, monitor);
    }

    private boolean generateResolution(GeneratorNode generatorNode, MaterializationContext context, IProgressMonitor monitor) throws CoreException {
        CSpec cspec = generatorNode.getDeclaringCSpec();
        try {
            IPerformManager performManager = CorePlugin.getPerformManager();
            Attribute generatorAttribute = cspec.getReferencedAttribute(generatorNode.getComponent(), null, null, generatorNode.getAttribute(), new ModelCache());
            if (generatorAttribute != null) {
                performManager.perform(Collections.singletonList(generatorAttribute), context, false, false, monitor);
                return true;
            }
        }
        catch (CoreException e) {
            if (!context.isContinueOnError()) {
                throw e;
            }
            context.addRequestStatus(generatorNode.getRequest(), e.getStatus());
        }
        return false;
    }
}

