/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.parser.ComponentRequestHandler;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.parser.IDWrapperHandler;
import org.eclipse.buckminster.core.metadata.parser.VersionMatchHandler;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ResolutionHandler
extends ExtensionAwareHandler
implements ChildPoppedListener {
    public static final String TAG = "resolution";
    private final ComponentRequestHandler componentRequestHandler = new ComponentRequestHandler((AbstractHandler)this, new ComponentRequestBuilder());
    private final VersionMatchHandler versionMatchHandler = new VersionMatchHandler((AbstractHandler)this);
    private final ArrayList<String> attributes = new ArrayList();
    private UUID cspecId;
    private UUID providerId;
    private ComponentRequest request;
    private String componentType;
    private VersionMatch versionMatch;
    private boolean materializable;
    private String persistentId;
    private String repository;
    private String remoteName;
    private String contentType;
    private long lastModified;
    private long size;
    private boolean unpack;

    public ResolutionHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.componentRequestHandler) {
            this.request = this.componentRequestHandler.getBuilder().createComponentRequest();
        } else if (child == this.versionMatchHandler) {
            this.versionMatch = this.versionMatchHandler.getVersionMatch();
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ExtensionAwareHandler ch = "request".equals(localName) ? this.componentRequestHandler : ("versionMatch".equals(localName) ? this.versionMatchHandler : super.createHandler(uri, localName, attrs));
        return ch;
    }

    public Resolution getResolution() throws SAXException {
        Provider provider;
        CSpec cspec;
        AbstractHandler parent;
        if (this.request == null) {
            throw new SAXParseException(NLS.bind((String)Messages.Missing_required_element_0, (Object)"md.request"), this.getDocumentLocator());
        }
        if (this.versionMatch == null) {
            throw new SAXParseException(NLS.bind((String)Messages.Missing_required_element_0, (Object)"md.versionMatch"), this.getDocumentLocator());
        }
        if (this.componentType == null) {
            this.componentType = this.legacyComponentType();
        }
        if ((parent = this.getParentHandler()) instanceof IDWrapperHandler) {
            IDWrapperHandler wh = (IDWrapperHandler)parent;
            cspec = (CSpec)wh.getWrapped(this.cspecId);
            provider = (Provider)wh.getWrapped(this.providerId);
        } else {
            try {
                StorageManager sm = StorageManager.getDefault();
                cspec = sm.getCSpecs().getElement(this.cspecId);
                provider = sm.getProviders().getElement(this.providerId);
            }
            catch (CoreException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        }
        return new Resolution(cspec, this.componentType, this.versionMatch, provider, this.materializable, this.request, this.attributes, this.persistentId, this.repository, this.remoteName, this.contentType, this.lastModified, this.size, this.unpack);
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.versionMatch = null;
        this.cspecId = UUID.fromString(this.getStringValue(attrs, "cspecId"));
        this.materializable = this.getBooleanValue(attrs, "materializable");
        this.providerId = UUID.fromString(this.getStringValue(attrs, "providerId"));
        this.componentType = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"componentType");
        this.persistentId = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"persistentId");
        this.repository = this.getStringValue(attrs, "repository");
        this.remoteName = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"remoteName");
        this.contentType = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"contentType");
        this.size = ResolutionHandler.getOptionalLongValue((Attributes)attrs, (String)"size", (long)-1L);
        this.lastModified = ResolutionHandler.getOptionalLongValue((Attributes)attrs, (String)"lastModified", (long)-1L);
        this.unpack = ResolutionHandler.getOptionalBooleanValue((Attributes)attrs, (String)"unpack", (boolean)false);
        this.request = null;
        this.attributes.clear();
        String attrStr = ResolutionHandler.getOptionalStringValue((Attributes)attrs, (String)"attributes");
        if (attrStr != null) {
            String[] stringArray = attrStr.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                if (!this.attributes.contains(attr)) {
                    this.attributes.add(attr);
                }
                ++n2;
            }
        }
    }

    private String legacyComponentType() throws SAXException {
        Provider provider;
        ICSpecData cspec;
        AbstractHandler parent = this.getParentHandler();
        if (parent instanceof IDWrapperHandler) {
            IDWrapperHandler wh = (IDWrapperHandler)parent;
            cspec = (ICSpecData)wh.getWrapped(this.cspecId);
            provider = (Provider)wh.getWrapped(this.providerId);
        } else {
            try {
                StorageManager sm = StorageManager.getDefault();
                cspec = sm.getCSpecs().getElement(this.cspecId);
                provider = sm.getProviders().getElement(this.providerId);
            }
            catch (CoreException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        }
        String[] ctypeIDs = provider.getComponentTypeIDs();
        if (ctypeIDs.length == 1) {
            return ctypeIDs[0];
        }
        String ctype = cspec.getComponentIdentifier().getComponentTypeID();
        if (ctype != null) {
            return ctype;
        }
        if (ctypeIDs.length == 3 && ctypeIDs[0].equals("osgi.bundle") && ctypeIDs[1].equals("eclipse.feature") && ctypeIDs[2].equals("buckminster")) {
            return "buckminster";
        }
        return "unknown";
    }
}

