/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.installer;

import java.net.URI;
import java.util.Arrays;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.installer.FeatureQuery;
import org.eclipse.buckminster.installer.Install;
import org.eclipse.buckminster.installer.Messages;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class ListSite
extends AbstractCommand {
    private URI site;

    static IInstallableUnit[] getRootIUs(URI site, IProgressMonitor monitor) throws CoreException {
        Buckminster bucky = Buckminster.getDefault();
        IProvisioningAgentProvider agentProvider = (IProvisioningAgentProvider)bucky.getService(IProvisioningAgentProvider.class);
        IProvisioningAgent agent = agentProvider.createAgent(null);
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            Object roots;
            if (site == null) {
                IProfileRegistry registry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
                IProfile runningInstanceProfile = registry.getProfile("_SELF_");
                roots = runningInstanceProfile != null ? runningInstanceProfile.query(QueryUtil.createLatestQuery((IQuery)new FeatureQuery()), (IProgressMonitor)subMon.newChild(10)) : Collector.emptyCollector();
            } else {
                IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
                roots = repoManager.loadRepository(site, (IProgressMonitor)subMon.newChild(8)).query(QueryUtil.createLatestQuery((IQuery)new FeatureQuery()), (IProgressMonitor)subMon.newChild(2));
            }
            IInstallableUnit[] iInstallableUnitArray = (IInstallableUnit[])roots.toArray(IInstallableUnit.class);
            return iInstallableUnitArray;
        }
        finally {
            agent.stop();
            bucky.ungetService((Object)agentProvider);
            subMon.done();
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        int len = unparsed.length;
        if (len > 1) {
            throw new SimpleErrorExitException(Messages.too_many_arguments);
        }
        if (len == 1) {
            this.site = Install.normalizeToURI(unparsed[0]);
        }
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(null, -1);
        System.out.println(Messages.feature_listing_heading);
        Object[] roots = ListSite.getRootIUs(this.site, monitor);
        Arrays.sort(roots);
        Object[] objectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Object iu = objectArray[n2];
            System.out.print("  ");
            String id = iu.getId();
            if (id.endsWith(".feature.group")) {
                id = id.substring(0, id.length() - 14);
            }
            System.out.print(id);
            String label = iu.getProperty("org.eclipse.equinox.p2.name");
            if (label != null) {
                System.out.print(" (");
                System.out.print(label);
                System.out.println(")");
            }
            ++n2;
        }
        return 0;
    }
}

