/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.model.common.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.model.common.CommonPackage;
import org.eclipse.buckminster.model.common.Match;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

public class MatchImpl
extends EObjectImpl
implements Match {
    protected static final String PATTERN_EDEFAULT = null;
    protected String pattern = PATTERN_EDEFAULT;
    protected static final boolean QUOTE_PATTERN_EDEFAULT = false;
    protected boolean quotePattern = false;
    protected boolean quotePatternESet;
    protected static final String REPLACEMENT_EDEFAULT = null;
    protected String replacement = REPLACEMENT_EDEFAULT;
    protected static final Pattern COMPILED_PATTERN_EDEFAULT = null;
    protected Pattern compiledPattern = COMPILED_PATTERN_EDEFAULT;

    protected MatchImpl() {
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getPattern();
            }
            case 1: {
                return this.isQuotePattern();
            }
            case 2: {
                return this.getReplacement();
            }
            case 3: {
                return this.getCompiledPattern();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return PATTERN_EDEFAULT == null ? this.pattern != null : !PATTERN_EDEFAULT.equals(this.pattern);
            }
            case 1: {
                return this.isSetQuotePattern();
            }
            case 2: {
                return REPLACEMENT_EDEFAULT == null ? this.replacement != null : !REPLACEMENT_EDEFAULT.equals(this.replacement);
            }
            case 3: {
                return COMPILED_PATTERN_EDEFAULT == null ? this.compiledPattern != null : !COMPILED_PATTERN_EDEFAULT.equals(this.compiledPattern);
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setPattern((String)newValue);
                return;
            }
            case 1: {
                this.setQuotePattern((Boolean)newValue);
                return;
            }
            case 2: {
                this.setReplacement((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setPattern(PATTERN_EDEFAULT);
                return;
            }
            case 1: {
                this.unsetQuotePattern();
                return;
            }
            case 2: {
                this.setReplacement(REPLACEMENT_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public synchronized Pattern getCompiledPattern() {
        if (this.compiledPattern == null) {
            String tmp = this.getPattern();
            if (tmp == null) {
                return null;
            }
            if (this.isQuotePattern()) {
                tmp = Pattern.quote(tmp);
            }
            this.compiledPattern = Pattern.compile(tmp);
        }
        return this.compiledPattern;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public String getReplacement() {
        return this.replacement;
    }

    @Override
    public boolean isQuotePattern() {
        return this.quotePattern;
    }

    @Override
    public boolean isSetQuotePattern() {
        return this.quotePatternESet;
    }

    @Override
    public String match(String resolved) {
        Matcher matcher = this.getCompiledPattern().matcher(resolved);
        if (matcher.find()) {
            StringBuffer sb = new StringBuffer();
            do {
                matcher.appendReplacement(sb, this.getReplacement());
            } while (matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return null;
    }

    @Override
    public synchronized void setPattern(String newPattern) {
        this.setPatternGen(newPattern);
        this.compiledPattern = null;
    }

    public void setPatternGen(String newPattern) {
        String oldPattern = this.pattern;
        this.pattern = newPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldPattern, (Object)this.pattern));
        }
    }

    @Override
    public synchronized void setQuotePattern(boolean newQuotePattern) {
        this.setQuotePatternGen(newQuotePattern);
        this.compiledPattern = null;
    }

    public void setQuotePatternGen(boolean newQuotePattern) {
        boolean oldQuotePattern = this.quotePattern;
        this.quotePattern = newQuotePattern;
        boolean oldQuotePatternESet = this.quotePatternESet;
        this.quotePatternESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldQuotePattern, this.quotePattern, !oldQuotePatternESet));
        }
    }

    @Override
    public void setReplacement(String newReplacement) {
        String oldReplacement = this.replacement;
        this.replacement = newReplacement;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldReplacement, (Object)this.replacement));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (pattern: ");
        result.append(this.pattern);
        result.append(", quotePattern: ");
        if (this.quotePatternESet) {
            result.append(this.quotePattern);
        } else {
            result.append("<unset>");
        }
        result.append(", replacement: ");
        result.append(this.replacement);
        result.append(", compiledPattern: ");
        result.append(this.compiledPattern);
        result.append(')');
        return result.toString();
    }

    @Override
    public void unsetQuotePattern() {
        boolean oldQuotePattern = this.quotePattern;
        boolean oldQuotePatternESet = this.quotePatternESet;
        this.quotePattern = false;
        this.quotePatternESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 1, oldQuotePattern, false, oldQuotePatternESet));
        }
    }

    protected EClass eStaticClass() {
        return CommonPackage.Literals.MATCH;
    }
}

