/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subclipse.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.subclipse.Messages;
import org.eclipse.buckminster.subclipse.internal.SvnCache;
import org.eclipse.buckminster.subclipse.internal.SvnEntryHelper;
import org.eclipse.buckminster.subclipse.internal.TypeTranslator;
import org.eclipse.buckminster.subversion.GenericCache;
import org.eclipse.buckminster.subversion.GenericSession;
import org.eclipse.buckminster.subversion.ISubversionCache;
import org.eclipse.buckminster.subversion.ISvnEntryHelper;
import org.eclipse.buckminster.subversion.RepositoryAccess;
import org.eclipse.buckminster.subversion.SvnExceptionHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.tigris.subversion.clientadapter.Activator;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNClientManager;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.repo.SVNRepositories;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnSession
extends GenericSession<ISVNRepositoryLocation, ISVNDirEntry, SVNRevision> {
    private static final SvnEntryHelper HELPER = new SvnEntryHelper();
    private static final ISVNDirEntry[] emptyFolder = new ISVNDirEntry[0];
    private ISVNClientAdapter clientAdapter;
    private static final String UNKNOWN_ROOT_PREFIX = String.valueOf(SvnSession.class.getPackage().getName()) + ".root.";

    private static SVNProviderPlugin getPlugin() {
        return SVNProviderPlugin.getPlugin();
    }

    private static SVNRepositories getRepositories() {
        return SvnSession.getPlugin().getRepositories();
    }

    public SvnSession(String repositoryURI, VersionSelector branchOrTag, long revision, Date timestamp, RMContext context) throws CoreException {
        super(repositoryURI, branchOrTag, revision, timestamp, context);
    }

    public void close() {
        this.clientAdapter.dispose();
    }

    public ISVNRepositoryLocation[] getKnownRepositories() throws CoreException {
        return SvnSession.getRepositories().getKnownRepositories((IProgressMonitor)new NullProgressMonitor());
    }

    public long getLastChangeNumber() throws CoreException {
        try {
            SVNUrl svnURL = TypeTranslator.from(this.getSVNUrl(null));
            ISVNDirEntry root = this.clientAdapter.getDirEntry(svnURL, (SVNRevision)this.getRevision());
            if (root == null) {
                throw new FileNotFoundException(svnURL.toString());
            }
            return root.getLastChangedRevision().getNumber();
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public long getLastChangeNumber(File workingCopy) throws CoreException {
        try {
            return this.clientAdapter.getInfoFromWorkingCopy(workingCopy).getLastChangedRevision().getNumber();
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public Date getLastTimestamp() throws CoreException {
        try {
            SVNUrl svnURL = TypeTranslator.from(this.getSVNUrl(null));
            ISVNDirEntry root = this.clientAdapter.getDirEntry(svnURL, (SVNRevision)this.getRevision());
            if (root == null) {
                throw new FileNotFoundException(svnURL.toString());
            }
            return root.getLastChangedDate();
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public SVNRevision.Number getRepositoryRevision(IProgressMonitor monitor) throws CoreException {
        SVNRevision.Number repoRev = null;
        if (this.getRevision() instanceof SVNRevision.Number) {
            repoRev = (SVNRevision.Number)this.getRevision();
            MonitorUtils.complete((IProgressMonitor)monitor);
        } else {
            monitor.beginTask(null, 1);
            try {
                int retries = 0;
                while (true) {
                    ISVNInfo info;
                    block14: {
                        try {
                            SVNUrl svnURL = TypeTranslator.from(this.getSVNUrl(null));
                            info = this.clientAdapter.getInfo(svnURL);
                            if (info != null) break block14;
                            return null;
                        }
                        catch (SVNClientException e) {
                            if (++retries < 3) {
                                try {
                                    Thread.sleep(2000L);
                                }
                                catch (InterruptedException interruptedException) {}
                            } else {
                                throw BuckminsterException.wrap((Throwable)e);
                            }
                            ++retries;
                            continue;
                        }
                    }
                    repoRev = info.getRevision();
                    break;
                }
            }
            finally {
                monitor.done();
            }
        }
        return repoRev;
    }

    public ISVNDirEntry getRootEntry(IProgressMonitor monitor) throws CoreException {
        String key;
        SVNUrl url = TypeTranslator.from(this.getSVNUrl(null));
        SVNUrl parent = url.getParent();
        if (parent != null) {
            ISVNDirEntry[] dirEntries;
            String lastEntry = url.getLastPathSegment();
            try {
                dirEntries = this.innerListFolder(TypeTranslator.from(url.getParent()), monitor);
            }
            catch (CoreException e) {
                dirEntries = emptyFolder;
            }
            ISVNDirEntry[] iSVNDirEntryArray = dirEntries;
            int n = dirEntries.length;
            int n2 = 0;
            while (n2 < n) {
                ISVNDirEntry dirEntry = iSVNDirEntryArray[n2];
                if (dirEntry.getPath().equals(lastEntry)) {
                    return dirEntry;
                }
                ++n2;
            }
        }
        SVNRevision revision = (SVNRevision)this.getRevision();
        String string = key = GenericCache.cacheKey((URI)TypeTranslator.from(url), (Object)this.getRevision()).intern();
        synchronized (string) {
            if (this.getCache().dirContainsKey(key)) {
                return this.getCache().getDir(key);
            }
            Logger logger = CorePlugin.getLogger();
            monitor.beginTask(null, 1);
            try {
                logger.debug("Obtaining remote folder %s[%s]", new Object[]{url, revision});
                ISVNDirEntry entry = this.getClientAdapter().getDirEntry(url, revision);
                this.getCache().putDir(key, entry);
                return entry;
            }
            catch (SVNClientException e) {
                if (SvnExceptionHandler.hasSvnException((Throwable)e)) {
                    logger.debug("Remote folder does not exist %s[%s]", new Object[]{url, revision});
                    this.getCache().putDir(key, null);
                    return null;
                }
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
    }

    public ISvnEntryHelper<ISVNDirEntry> getSvnEntryHelper() {
        return HELPER;
    }

    public SVNRevision getSVNRevision(long revision, Date timestamp) {
        if (revision == -1L) {
            if (timestamp == null) {
                return SVNRevision.HEAD;
            }
            return new SVNRevision.DateSpec(timestamp);
        }
        if (timestamp != null) {
            throw new IllegalArgumentException(org.eclipse.buckminster.subversion.Messages.svn_session_cannot_use_both_timestamp_and_revision_number);
        }
        return new SVNRevision.Number(revision);
    }

    public String toString() {
        try {
            return this.getSVNUrl(null).toString();
        }
        catch (CoreException e) {
            return super.toString();
        }
    }

    protected void createRoots(Collection<RepositoryAccess> sourceRoots) throws CoreException {
        SVNRepositories repos = SvnSession.getRepositories();
        for (RepositoryAccess root : sourceRoots) {
            String pwd;
            Properties configuration = new Properties();
            configuration.setProperty("url", root.getSvnURL().toString());
            String user = root.getUser();
            if (user != null) {
                configuration.setProperty("user", user);
            }
            if ((pwd = root.getPassword()) != null) {
                configuration.setProperty("password", pwd);
            }
            try {
                ISVNRepositoryLocation repoLocation = repos.createRepository(configuration);
                repos.addOrUpdateRepository(repoLocation);
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
    }

    protected ISubversionCache<ISVNDirEntry> getCache(Map<UUID, Object> userCache) {
        assert (this.cache == null);
        SvnCache svnCache = new SvnCache();
        svnCache.initialize(userCache);
        return svnCache;
    }

    protected ISVNDirEntry[] getEmptyEntryList() {
        return emptyFolder;
    }

    protected String getRootUrl(ISVNRepositoryLocation location) {
        return location.getRepositoryRoot().toString();
    }

    protected String getUnknownRootPrefix() {
        return UNKNOWN_ROOT_PREFIX;
    }

    protected void initializeSvn(RMContext context, URI ourRoot, ISVNRepositoryLocation bestMatch) throws CoreException {
        ISVNPromptUserPassword pwCb;
        SVNProviderPlugin plugin = SvnSession.getPlugin();
        ISVNClientAdapter client = this.getClientAdapter();
        Object object = pwCb = this.username == null ? plugin.getSvnPromptUserPassword() : new UnattendedPromptUserPassword();
        if (pwCb != null) {
            client.addPasswordCallback(pwCb);
        }
        this.clientAdapter = client;
        if (bestMatch == null) {
            this.addUnknownRoot(context.getBindingProperties(), new RepositoryAccess(ourRoot, this.username, this.password));
        }
    }

    protected ISVNDirEntry[] innerListFolder(URI url, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 1);
        try {
            ISVNDirEntry[] iSVNDirEntryArray = this.clientAdapter.getList(TypeTranslator.from(url), (SVNRevision)this.getRevision(), (SVNRevision)this.getRevision(), false);
            return iSVNDirEntryArray;
        }
        catch (SVNClientException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            monitor.worked(1);
        }
    }

    ISVNClientAdapter getClientAdapter() throws CoreException {
        if (this.clientAdapter == null) {
            SVNClientManager clientManager = SvnSession.getPlugin().getSVNClientManager();
            this.clientAdapter = Activator.getDefault().getClientAdapter(clientManager.getSvnClientInterface());
            if (this.clientAdapter == null) {
                this.clientAdapter = Activator.getDefault().getAnyClientAdapter();
            }
            if (this.clientAdapter == null) {
                throw BuckminsterException.fromMessage((String)Messages.unable_to_load_default_svn_client, (Object[])new Object[0]);
            }
        }
        return this.clientAdapter;
    }

    private SvnCache getCache() {
        return (SvnCache)this.cache;
    }

    private class UnattendedPromptUserPassword
    implements ISVNPromptUserPassword {
        private int promptPasswordLimit = 3;
        private int promptUserLimit = 3;

        private UnattendedPromptUserPassword() {
        }

        public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
            return null;
        }

        public int askTrustSSLServer(String info, boolean allowPermanently) {
            return 1;
        }

        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            return yesIsDefault;
        }

        public String getPassword() {
            return SvnSession.this.password;
        }

        public int getSSHPort() {
            return -1;
        }

        public String getSSHPrivateKeyPassphrase() {
            return null;
        }

        public String getSSHPrivateKeyPath() {
            return null;
        }

        public String getSSLClientCertPassword() {
            return null;
        }

        public String getSSLClientCertPath() {
            return null;
        }

        public String getUsername() {
            return SvnSession.this.username;
        }

        public boolean prompt(String realm, String user, boolean maySave) {
            return SvnSession.this.password != null && --this.promptPasswordLimit >= 0;
        }

        public boolean promptSSH(String realm, String user, int sshPort, boolean maySave) {
            return false;
        }

        public boolean promptSSL(String realm, boolean maySave) {
            return false;
        }

        public boolean promptUser(String realm, String user, boolean maySave) {
            return --this.promptUserLimit >= 0;
        }

        public boolean userAllowedSave() {
            return false;
        }
    }
}

