/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider;

import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.ui.dependency.visualizer.resources.ImageCache;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.zest.core.viewers.EntityConnectionData;

public class DependencyLabelProvider
extends LabelProvider {
    public Image getImage(Object element) {
        if (element instanceof BOMNode) {
            BOMNode node = (BOMNode)element;
            String componentTypeID = node.getRequest().getComponentTypeID();
            Resolution resolution = node.getResolution();
            if (resolution != null) {
                componentTypeID = resolution.getComponentTypeId();
            }
            if ("osgi.bundle".equals(componentTypeID)) {
                return ImageCache.getImage("icons/osgi16x16.png");
            }
            if ("maven".equals(componentTypeID)) {
                return ImageCache.getImage("icons/apache.png");
            }
            if ("buckminster".equals(componentTypeID)) {
                return ImageCache.getImage("icons/component.png");
            }
            if ("eclipse.feature".equals(componentTypeID)) {
                return ImageCache.getImage("icons/eclipse.gif");
            }
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof BOMNode) {
            BOMNode node = (BOMNode)element;
            return node.getRequest().getName();
        }
        if (element instanceof EntityConnectionData) {
            return "";
        }
        return super.getText(element);
    }
}

