/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.DateAndTimeUtils;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.IDWrapper;
import org.eclipse.buckminster.core.metadata.parser.BomNodeHandler;
import org.eclipse.buckminster.core.metadata.parser.IDWrapperHandler;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BillOfMaterialsHandler
extends BomNodeHandler
implements ChildPoppedListener {
    public static final String TAG = "billOfMaterials";
    private final Map<UUID, IDWrapper> wrapperMap = new HashMap<UUID, IDWrapper>();
    private final IDWrapperHandler idWrapperHandler = new IDWrapperHandler((AbstractHandler)this);
    private UUID topNodeId;
    private UUID queryId;
    private Date timestamp;

    public BillOfMaterialsHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.idWrapperHandler) {
            IDWrapper wrapper = this.idWrapperHandler.getWrapper();
            this.wrapperMap.put(wrapper.getId(), wrapper);
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        IDWrapperHandler ch = "idwrapper".equals(localName) ? this.idWrapperHandler : super.createHandler(uri, localName, attrs);
        return ch;
    }

    public UUIDKeyed getWrapped(UUID id) throws SAXException {
        IDWrapper wrapper = this.wrapperMap.get(id);
        if (wrapper == null) {
            AbstractHandler parent = this.getParentHandler();
            while (parent != null) {
                if (parent instanceof BillOfMaterialsHandler) {
                    return ((BillOfMaterialsHandler)parent).getWrapped(id);
                }
                if (!(parent instanceof ChildHandler)) continue;
                parent = ((ChildHandler)parent).getParentHandler();
            }
            throw new SAXParseException(NLS.bind((String)Messages.Id_0_appoints_non_existing_wrapper, (Object)id), this.getDocumentLocator());
        }
        return wrapper.getWrapped();
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        super.handleAttributes(attrs);
        this.wrapperMap.clear();
        try {
            String tmp = BillOfMaterialsHandler.getOptionalStringValue((Attributes)attrs, (String)"topNodeId");
            this.topNodeId = tmp == null ? null : UUID.fromString(tmp);
            this.queryId = UUID.fromString(this.getStringValue(attrs, "componentQueryId"));
            this.timestamp = DateAndTimeUtils.fromISOFormat(this.getStringValue(attrs, "timestamp"));
        }
        catch (IllegalArgumentException e) {
            throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
        }
        catch (ParseException e) {
            throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
        }
    }

    BOMNode getDepNode() throws SAXException {
        return new BillOfMaterials((BOMNode)this.getWrapped(this.topNodeId), this.getQuery(this.queryId), this.timestamp);
    }

    ComponentQuery getQuery(UUID qid) throws SAXException {
        try {
            return (ComponentQuery)this.getWrapped(qid);
        }
        catch (ClassCastException e) {
            throw new SAXParseException(NLS.bind((String)Messages.Wrapper_0_does_not_wrap_query, (Object)qid), this.getDocumentLocator());
        }
    }
}

