/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jarprocessor;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.jarprocessor.IConstants;
import org.eclipse.buckminster.jarprocessor.RecursivePack200;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JarInfo
implements IConstants {
    static final String PROP_PACK200_CONDITIONED = "pack200.conditioned";
    static final String PROP_PACK200_ARGS = "pack200.args";
    static final String PROP_PACK200_DEFAULT_ARGS = "pack200.default.args";
    static final String PROP_IS_EXCLUDE = "jarprocessor.exclude";
    static final String PROP_IS_EXCLUDE_PACK = "jarprocessor.exclude.pack";
    static final String PROP_IS_EXCLUDE_SIGN = "jarprocessor.exclude.sign";
    static final String PROP_IS_EXCLUDE_CHILDREN = "jarprocessor.exclude.children";
    static final String PROP_BUCK_IS_EXCLUDE_CHILDREN = "buckminster.exclude.children";
    static final String PROP_IS_EXCLUDE_CHILDREN_PACK = "jarprocessor.exclude.children.pack";
    static final String PROP_IS_EXCLUDE_CHILDREN_SIGN = "jarprocessor.exclude.children.sign";
    private boolean signed = false;
    private boolean classes = false;
    private final String jarName;
    private final JarInfo parent;
    private Map<String, JarInfo> nestedInfos = null;
    private Map<String, String> eclipseInf = null;

    static JarInfo getJarInfo(JarInfo parent, String jarName, ZipInputStream input) throws IOException {
        ZipEntry entry;
        JarInfo jarInfo = new JarInfo(parent, jarName);
        HashSet<String> alreadyPacked = new HashSet<String>();
        while ((entry = input.getNextEntry()) != null) {
            String name = entry.getName();
            if (name.endsWith(".jar")) {
                JarInfo nested;
                if (alreadyPacked.contains(name) || (nested = JarInfo.getJarInfo(jarInfo, name, new JarInputStream(input))).isSigned() && !nested.isConditioned() || !nested.hasClasses() && !nested.isNested()) continue;
                if (jarInfo.nestedInfos == null) {
                    jarInfo.nestedInfos = new HashMap<String, JarInfo>();
                }
                jarInfo.nestedInfos.put(name, nested);
                continue;
            }
            if (!jarInfo.classes && name.endsWith(".class")) {
                jarInfo.classes = true;
                continue;
            }
            if (name.endsWith(".pack")) {
                alreadyPacked.add(name.substring(0, name.length() - ".pack".length()));
                continue;
            }
            if (name.endsWith(".pack.gz")) {
                alreadyPacked.add(name.substring(0, name.length() - ".pack.gz".length()));
                continue;
            }
            if (!name.startsWith("META-INF/") || (name = name.substring("META-INF/".length())).indexOf(47) > 0) continue;
            if (jarInfo.eclipseInf == null && name.equals("eclipse.inf")) {
                jarInfo.eclipseInf = new BMProperties((InputStream)input);
                continue;
            }
            if (!name.endsWith(".SF")) continue;
            jarInfo.signed = true;
        }
        if (jarInfo.eclipseInf == null) {
            jarInfo.eclipseInf = Collections.emptyMap();
        }
        if (jarInfo.nestedInfos == null || jarInfo.isExcludeChildren()) {
            jarInfo.nestedInfos = Collections.emptyMap();
        } else {
            for (String name : alreadyPacked) {
                jarInfo.nestedInfos.remove(name);
            }
        }
        return jarInfo;
    }

    private JarInfo(JarInfo parentInfo, String jname) {
        this.parent = parentInfo;
        this.jarName = jname;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        this.toString(bld);
        return bld.toString();
    }

    void appendArgs(List<String> args) {
        this.appendArgs(args, true);
    }

    Map<String, String> getEclipseInf() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.eclipseInf != null) {
            map.putAll(this.eclipseInf);
        }
        ArrayList<String> args = new ArrayList<String>();
        this.appendArgs(args);
        if (!args.isEmpty()) {
            map.put(PROP_PACK200_ARGS, TextUtils.concat(args, (String)" "));
        }
        return map;
    }

    JarInfo getNestedInfo(String name) {
        return this.nestedInfos.get(name);
    }

    boolean hasClasses() {
        return this.classes;
    }

    boolean hasEclipseInf() {
        return this.eclipseInf != null && !this.eclipseInf.isEmpty();
    }

    boolean isConditioned() {
        return "true".equalsIgnoreCase(this.eclipseInf.get(PROP_PACK200_CONDITIONED));
    }

    boolean isExclude() {
        return "true".equalsIgnoreCase(this.eclipseInf.get(PROP_IS_EXCLUDE));
    }

    boolean isExcludeChildren() {
        String prop = this.eclipseInf.get(PROP_BUCK_IS_EXCLUDE_CHILDREN);
        if (prop == null) {
            prop = this.eclipseInf.get(PROP_IS_EXCLUDE_CHILDREN);
        }
        return "true".equalsIgnoreCase(prop);
    }

    boolean isExcludeChildrenPack() {
        return this.isExcludeChildren() || "true".equalsIgnoreCase(this.eclipseInf.get(PROP_IS_EXCLUDE_CHILDREN_PACK));
    }

    boolean isExcludeChildrenSign() {
        return this.isExcludeChildren() || "true".equalsIgnoreCase(this.eclipseInf.get(PROP_IS_EXCLUDE_CHILDREN_SIGN));
    }

    boolean isExcludePack() {
        return this.isExclude() || "true".equalsIgnoreCase(this.eclipseInf.get(PROP_IS_EXCLUDE_PACK));
    }

    boolean isExcludeSign() {
        return this.isExclude() || "true".equalsIgnoreCase(this.eclipseInf.get(PROP_IS_EXCLUDE_SIGN));
    }

    boolean isNested() {
        return !this.nestedInfos.isEmpty();
    }

    boolean isSigned() {
        return this.signed;
    }

    void toString(StringBuilder bld) {
        if (this.parent != null) {
            this.parent.toString(bld);
            bld.append("!/");
        }
        bld.append(this.jarName);
    }

    private void appendArgs(List<String> args, boolean atLeaf) {
        boolean hasEffort;
        block8: {
            if (this.parent != null) {
                this.parent.appendArgs(args, false);
                if (this.parent.isExcludeChildren()) {
                    return;
                }
            }
            hasEffort = false;
            if (atLeaf && !this.hasClasses()) {
                args.add("-E0");
                hasEffort = true;
            }
            if (this.eclipseInf == null) break block8;
            String[] stringArray = TextUtils.splitAndTrim((String)this.eclipseInf.get(PROP_PACK200_ARGS), (String)" \t\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    String arg;
                    block9: {
                        arg = stringArray[n2];
                        Matcher m = RecursivePack200.EFFORT_PATTERN.matcher(arg);
                        if (!m.matches()) break block9;
                        if (hasEffort || !atLeaf) break block10;
                        hasEffort = true;
                    }
                    args.add(arg);
                }
                ++n2;
            }
        }
        if (!hasEffort && atLeaf) {
            args.add("-E4");
        }
    }
}

