/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subversion;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.buckminster.runtime.Buckminster;

public class SvnExceptionHandler {
    private static final Map<String, String> MAPS = new HashMap<String, String>();

    static {
        SvnExceptionHandler.initializeExceptionMessages();
    }

    public static Throwable getRootCause(Throwable e) {
        Throwable t;
        Throwable p = e;
        String msg = e.getMessage();
        while (msg == null && (t = p.getCause()) != null) {
            p = t;
        }
        if (msg == null) {
            return e;
        }
        return p;
    }

    public static EExceptionType[] getSvnExceptionTypes(Throwable e) {
        HashSet<EExceptionType> exceptions = new HashSet<EExceptionType>();
        String message = e.getMessage();
        Set<String> keys = MAPS.keySet();
        for (String key : keys) {
            if (message.indexOf(key) == -1) continue;
            exceptions.add(SvnExceptionHandler.getExceptionTypeFromKey(key));
        }
        return exceptions.toArray(new EExceptionType[exceptions.size()]);
    }

    public static boolean hasSvnException(Throwable e) {
        String message = e.getMessage();
        if (message == null) {
            return false;
        }
        Set<String> keys = MAPS.keySet();
        for (String key : keys) {
            if (message.indexOf(key) == -1) continue;
            Buckminster.getLogger().debug("Found " + (Object)((Object)SvnExceptionHandler.getExceptionTypeFromKey(key)) + " exception from " + SvnExceptionHandler.getDescription(key), new Object[0]);
            return true;
        }
        return false;
    }

    private static String getDescription(String key) {
        String exceptionKey = MAPS.get(key);
        String[] parts = exceptionKey.split("\\|");
        String language = parts.length == 2 ? "default" : parts[2];
        return "subversion version " + parts[1] + " language " + language;
    }

    private static EExceptionType getExceptionTypeFromKey(String key) {
        String originalExceptionName = MAPS.get(key);
        if (originalExceptionName.startsWith("file_not_found")) {
            return EExceptionType.FILE_NOT_FOUND;
        }
        if (originalExceptionName.startsWith("path_not_found")) {
            return EExceptionType.PATH_NOT_FOUND;
        }
        if (originalExceptionName.startsWith("URL_non_existent")) {
            return EExceptionType.URL_NON_EXISTENT;
        }
        return EExceptionType.OTHER;
    }

    private static void initializeExceptionMessages() {
        try {
            Properties props = new Properties();
            props.load(SvnExceptionHandler.class.getResourceAsStream("svn_exception_messages.properties"));
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String exception = (String)entry.getKey();
                String message = (String)entry.getValue();
                MAPS.put(message, exception);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EExceptionType {
        FILE_NOT_FOUND,
        PATH_NOT_FOUND,
        URL_NON_EXISTENT,
        OTHER;

    }
}

