/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui;

import java.io.File;
import java.util.List;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.ui.AbstractCSpecAction;
import org.eclipse.buckminster.ui.InvokeActionJob;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.dialogs.InvokeActionDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Shell;

public class InvokeAction
extends AbstractCSpecAction {
    protected void run(CSpec cspec, Shell shell) {
        List viableAttributes;
        try {
            viableAttributes = cspec.getAttributesProducedByActions(true);
        }
        catch (CoreException e) {
            UiUtils.openError(shell, Messages.error_during_action_perform, e);
            return;
        }
        InvokeActionDialog dialog = new InvokeActionDialog(shell, String.valueOf(Messages.actions_of) + cspec.getName(), viableAttributes);
        this.openDialog(dialog);
    }

    protected void run(Shell shell) {
        InvokeActionDialog dialog = new InvokeActionDialog(shell, this);
        this.openDialog(dialog);
    }

    private void openDialog(InvokeActionDialog dialog) {
        if (dialog.open() != 0) {
            return;
        }
        File propertiesFile = dialog.getPropertiesFile();
        boolean forceRebuild = dialog.isForceRebuild();
        List<Attribute> attributes = dialog.getSelectedAttributes();
        if (attributes == null) {
            return;
        }
        InvokeActionJob job = new InvokeActionJob(attributes.get(0).getName(), attributes, propertiesFile, forceRebuild);
        job.schedule();
    }
}

