/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.buckminster.runtime.BuckminsterPreferences;
import org.eclipse.buckminster.ui.UiPlugin;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuckminsterIOConsole
extends IOConsole
implements IPropertyChangeListener {
    private static final RGB DEFAULT_COLOR = new RGB(0, 0, 0);
    private Set<IOConsoleOutputStream> messageStreamSet = new HashSet<IOConsoleOutputStream>();
    private Set<IOConsoleOutputStream> errorStreamSet = new HashSet<IOConsoleOutputStream>();
    private boolean showOnMessage;
    private boolean showOnError;
    private Color messageColor;
    private Color errorColor;

    public BuckminsterIOConsole(String name, String type) {
        super(name, type, null);
        this.initLimitOutput();
        this.showOnMessage = BuckminsterPreferences.isConsoleShowOnMessage();
        this.showOnError = BuckminsterPreferences.isConsoleShowOnError();
        this.messageColor = this.createColor(BuckminsterPreferences.getConsoleMessageColor());
        this.errorColor = this.createColor(BuckminsterPreferences.getConsoleErrorColor());
        UiPlugin.getDefault().getBuckminsterPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public IOConsoleOutputStream newOutputStream(boolean errorStream) {
        this.removeClosedStreams();
        IOConsoleOutputStream newStream = super.newOutputStream();
        if (errorStream) {
            newStream.setActivateOnWrite(this.showOnError);
            newStream.setColor(this.errorColor);
            this.errorStreamSet.add(newStream);
        } else {
            newStream.setActivateOnWrite(this.showOnMessage);
            newStream.setColor(this.messageColor);
            this.messageStreamSet.add(newStream);
        }
        return newStream;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.removeClosedStreams();
        String property = event.getProperty();
        if (property.equals("pref_console_message_color")) {
            Color newColor = this.createColor(BuckminsterPreferences.getConsoleMessageColor());
            this.setColor(this.messageStreamSet, newColor);
            this.messageColor.dispose();
            this.messageColor = newColor;
        } else if (property.equals("pref_console_error_color")) {
            Color newColor = this.createColor(BuckminsterPreferences.getConsoleErrorColor());
            this.setColor(this.errorStreamSet, newColor);
            this.errorColor.dispose();
            this.errorColor = newColor;
        } else if (property.equals("pref_console_limit_output") || property.equals("pref_console_high_water_mark")) {
            this.initLimitOutput();
        } else if (property.equals("pref_console_show_on_message")) {
            this.showOnMessage = BuckminsterPreferences.isConsoleShowOnMessage();
            this.setActivateOnWrite(this.messageStreamSet, this.showOnMessage);
        } else if (property.equals("pref_console_show_on_error")) {
            this.showOnError = BuckminsterPreferences.isConsoleShowOnError();
            this.setActivateOnWrite(this.errorStreamSet, this.showOnError);
        }
    }

    private Color createColor(String colorString) {
        RGB rgb = StringConverter.asRGB((String)colorString, null);
        if (rgb == null) {
            rgb = DEFAULT_COLOR;
        }
        return new Color((Device)Display.getCurrent(), rgb);
    }

    private void initLimitOutput() {
        if (BuckminsterPreferences.isConsoleLimitOutput()) {
            this.setWaterMarks(1000, BuckminsterPreferences.getConsoleHighWaterMark());
        } else {
            this.setWaterMarks(-1, 0);
        }
    }

    private void removeClosedStreams() {
        this.removeClosedStreams(this.messageStreamSet.iterator());
        this.removeClosedStreams(this.errorStreamSet.iterator());
    }

    private void removeClosedStreams(Iterator<IOConsoleOutputStream> iterator) {
        while (iterator.hasNext()) {
            if (!iterator.next().isClosed()) continue;
            iterator.remove();
        }
    }

    private void setActivateOnWrite(Set<IOConsoleOutputStream> streams, boolean activateOnWrite) {
        if (streams != null) {
            for (IOConsoleOutputStream stream : streams) {
                stream.setActivateOnWrite(activateOnWrite);
            }
        }
    }

    private void setColor(Set<IOConsoleOutputStream> streams, Color color) {
        if (streams != null) {
            for (IOConsoleOutputStream stream : streams) {
                stream.setColor(color);
            }
        }
    }
}

