/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.buckminster.core.helpers.FileHandle;
import org.eclipse.buckminster.core.helpers.ShortDurationFileCache;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.runtime.FileInfoBuilder;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;

public class ShortDurationURLCache
extends ShortDurationFileCache {
    public ShortDurationURLCache() {
        super(300000L, "url", "cache", null);
    }

    public ShortDurationURLCache(long keepAlive, String prefix, String suffix, File tempDir) {
        super(keepAlive, prefix, suffix, tempDir);
    }

    public InputStream openURL(final URL url, final IConnectContext cctx, IProgressMonitor monitor) throws IOException, CoreException {
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            return url.openStream();
        }
        return this.open(new ShortDurationFileCache.Materializer(){

            public String getKey() {
                return url.toString();
            }

            public FileHandle materialize(IProgressMonitor mon, FileInfoBuilder info) throws IOException, CoreException {
                if (info == null) {
                    info = new FileInfoBuilder();
                }
                File tempFile = null;
                boolean success = false;
                try {
                    tempFile = File.createTempFile("bmurl", ".cache");
                    FileOutputStream output = new FileOutputStream(tempFile);
                    try {
                        DownloadManager.readInto((URL)url, (IConnectContext)cctx, (OutputStream)output, (IProgressMonitor)mon);
                    }
                    finally {
                        IOUtils.close((Closeable)output);
                    }
                    success = true;
                    FileHandle fileHandle = new FileHandle(url.toString(), tempFile, true);
                    return fileHandle;
                }
                finally {
                    if (!success && tempFile != null) {
                        tempFile.delete();
                    }
                }
            }
        }, monitor);
    }
}

