/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.ctype;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.cspec.AbstractResolutionBuilder;
import org.eclipse.buckminster.core.ctype.MissingCSpecSourceException;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.UnresolvedNodeException;
import org.eclipse.buckminster.core.parser.IParser;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IFileReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BOMBuilder
extends AbstractResolutionBuilder
implements IStreamConsumer<BillOfMaterials> {
    @Override
    public synchronized BOMNode build(IComponentReader[] readerHandle, boolean forResolutionAidOnly, IProgressMonitor monitor) throws CoreException {
        IComponentReader reader = readerHandle[0];
        try {
            BillOfMaterials bom = reader instanceof ICatalogReader ? ((ICatalogReader)reader).readFile("buckminster.bom", this, monitor) : ((IFileReader)reader).readFile(this, monitor);
            if (bom.getResolution() == null) {
                throw new UnresolvedNodeException(reader.getNodeQuery().getComponentRequest());
            }
            return bom;
        }
        catch (FileNotFoundException e) {
            throw new MissingCSpecSourceException(reader.getProviderMatch());
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    public BillOfMaterials consumeStream(IComponentReader reader, String streamName, InputStream stream, IProgressMonitor monitor) throws CoreException {
        IParser<BillOfMaterials> bomParser = CorePlugin.getDefault().getParserFactory().getBillOfMaterialsParser(true);
        return bomParser.parse(streamName, stream);
    }
}

