/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import java.util.Date;
import java.util.List;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.AbstractVersionFinder;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSCCSVersionFinder
extends AbstractVersionFinder {
    protected AbstractSCCSVersionFinder(Provider provider, IComponentType componentType, NodeQuery query) {
        super(provider, componentType, query);
    }

    @Override
    public VersionMatch getBestVersion(IProgressMonitor monitor) throws CoreException {
        try {
            VersionMatch match;
            NodeQuery query = this.getQuery();
            VersionSelector[] branchTagPath = query.getBranchTagPath();
            int idx = branchTagPath.length;
            boolean branches = false;
            boolean tags = false;
            boolean trunk = idx == 0;
            while (--idx >= 0) {
                VersionSelector branchOrTag = branchTagPath[idx];
                if (branchOrTag.getType() == 0) {
                    branches = true;
                } else {
                    tags = true;
                }
                if (!branchOrTag.isDefault()) continue;
                trunk = true;
            }
            IVersionConverter versionConverter = this.getProvider().getVersionConverter();
            if (versionConverter != null) {
                this.logDecision(ResolverDecisionType.USING_VERSION_CONVERTER, versionConverter.getId());
                trunk = false;
                if (versionConverter.getSelectorType() == 0) {
                    if (!tags) {
                        branches = true;
                    }
                } else if (!branches) {
                    tags = true;
                }
                if (!branches && !tags) {
                    MonitorUtils.complete((IProgressMonitor)monitor);
                    return null;
                }
            }
            int ticks = 0;
            if (trunk) {
                this.logDecision(ResolverDecisionType.SEARCHING_TRUNK, new Object[0]);
                ticks += 10;
            }
            if (branches) {
                this.logDecision(ResolverDecisionType.SEARCHING_BRANCHES, new Object[0]);
                ticks += 10;
            }
            if (tags) {
                this.logDecision(ResolverDecisionType.SEARCHING_TAGS, new Object[0]);
                ticks += 10;
            }
            monitor.beginTask(null, ticks);
            VersionMatch best = null;
            if (branches) {
                best = this.getBestBranchOrTagMatch(true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
            }
            if (tags) {
                match = this.getBestBranchOrTagMatch(false, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
                if (best == null) {
                    best = match;
                } else if (match != null && query.compare(match, best) > 0) {
                    this.logDecision(ResolverDecisionType.MATCH_REJECTED, new Object[]{best, NLS.bind((String)Messages._0_is_a_better_match, (Object)((Object)match))});
                    best = match;
                }
            }
            if (trunk) {
                match = this.getBestTrunkMatch(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
                if (best == null) {
                    best = match;
                } else if (match != null && query.compare(match, best) > 0) {
                    this.logDecision(ResolverDecisionType.MATCH_REJECTED, new Object[]{best, NLS.bind((String)Messages._0_is_a_better_match, (Object)((Object)match))});
                    best = match;
                }
            }
            VersionMatch versionMatch = best;
            return versionMatch;
        }
        finally {
            monitor.done();
        }
    }

    protected abstract boolean checkComponentExistence(VersionMatch var1, IProgressMonitor var2) throws CoreException;

    protected VersionMatch getBestBranchOrTagMatch(boolean branches, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 100);
        try {
            List<RevisionEntry> entries = this.getBranchesOrTags(branches, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            VersionMatch versionMatch = this.getBestBranchOrTagMatch(branches, entries, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            return versionMatch;
        }
        finally {
            monitor.done();
        }
    }

    protected VersionMatch getBestBranchOrTagMatch(boolean branches, List<RevisionEntry> entries, IProgressMonitor monitor) throws CoreException {
        int top = entries.size();
        if (top == 0) {
            this.logDecision(branches ? ResolverDecisionType.NO_BRANCHES_FOUND : ResolverDecisionType.NO_TAGS_FOUND, new Object[0]);
            MonitorUtils.complete((IProgressMonitor)monitor);
            return null;
        }
        IVersionConverter vConverter = this.getProvider().getVersionConverter();
        if (vConverter != null && vConverter.getSelectorType() != (branches ? 0 : 1)) {
            if (branches) {
                this.logDecision(ResolverDecisionType.VERSION_SELECTOR_MISMATCH, "tags", "branches");
            } else {
                this.logDecision(ResolverDecisionType.VERSION_SELECTOR_MISMATCH, "branches", "tags");
            }
            MonitorUtils.complete((IProgressMonitor)monitor);
            return null;
        }
        monitor.beginTask(null, top * 10);
        NodeQuery query = this.getQuery();
        VersionSelector[] branchTagPath = query.getBranchTagPath();
        VersionRange versionRange = query.getVersionRange();
        String revision = query.getRevision();
        Date timestamp = query.getTimestamp();
        VersionMatch best = null;
        for (RevisionEntry entry : entries) {
            Version version;
            VersionSelector branchOrTag;
            Date entryTs;
            if (!entry.satisfiesRevision(revision)) {
                this.logDecision(ResolverDecisionType.REVISION_REJECTED, Long.valueOf(entry.getRevision()), "too high");
                continue;
            }
            if (timestamp != null && (entryTs = entry.getTimestamp()) != null && entryTs.compareTo(timestamp) > 0) {
                this.logDecision(ResolverDecisionType.TIMESTAMP_REJECTED, entryTs, "too young");
                continue;
            }
            String name = entry.getEntryName();
            VersionSelector versionSelector = branchOrTag = branches ? VersionSelector.branch(name) : VersionSelector.tag(name);
            if (branchTagPath.length > 0 && VersionSelector.indexOf(branchTagPath, branchOrTag) < 0) {
                this.logDecision(branches ? ResolverDecisionType.BRANCH_REJECTED : ResolverDecisionType.TAG_REJECTED, branchOrTag, NLS.bind((String)Messages.r_not_in_path_0, (Object)VersionSelector.toString(branchTagPath)));
                continue;
            }
            VersionMatch match = null;
            if (vConverter != null) {
                version = vConverter.createVersion(branchOrTag);
                if (version == null) {
                    this.logDecision(branches ? ResolverDecisionType.BRANCH_REJECTED : ResolverDecisionType.TAG_REJECTED, branchOrTag, Messages.VersionSelector_cannot_make_sense_of_it);
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)10);
                    continue;
                }
                match = new VersionMatch(version, branchOrTag, entry.getRevision(), entry.getTimestamp(), null);
                if (!this.checkComponentExistence(match, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10))) {
                    this.logDecision(branches ? ResolverDecisionType.BRANCH_REJECTED : ResolverDecisionType.TAG_REJECTED, branchOrTag, Messages.No_component_was_found);
                    continue;
                }
                this.logDecision(branches ? ResolverDecisionType.USING_BRANCH_CONVERTED_VERSION : ResolverDecisionType.USING_TAG_CONVERTED_VERSION, version, branchOrTag);
            } else {
                try {
                    version = this.getVersionFromArtifacts(branchOrTag, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
                }
                catch (CoreException e) {
                    this.logDecision(branches ? ResolverDecisionType.BRANCH_REJECTED : ResolverDecisionType.TAG_REJECTED, branchOrTag, e.getMessage());
                    continue;
                }
            }
            if (versionRange != null && !versionRange.isIncluded(version)) {
                this.logDecision(ResolverDecisionType.VERSION_REJECTED, version, NLS.bind((String)Messages.Not_designated_by_0, (Object)versionRange));
                continue;
            }
            if (match == null) {
                match = new VersionMatch(version, branchOrTag, entry.getRevision(), entry.getTimestamp(), null);
            }
            if (version == null && !this.checkComponentExistence(match, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10))) {
                this.logDecision(branches ? ResolverDecisionType.BRANCH_REJECTED : ResolverDecisionType.TAG_REJECTED, branchOrTag, Messages.No_component_was_found);
                continue;
            }
            if (best != null && query.compare(match, best) <= 0) continue;
            if (best != null) {
                this.logDecision(ResolverDecisionType.MATCH_REJECTED, new Object[]{best, NLS.bind((String)Messages._0_is_a_better_match, (Object)((Object)match))});
            }
            best = match;
            if (vConverter != null && versionRange != null && versionRange.getMinimum().equals(versionRange.getMaximum())) break;
        }
        monitor.done();
        return best;
    }

    protected VersionMatch getBestTrunkMatch(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 100);
        try {
            Date entryTs;
            RevisionEntry entry = this.getTrunk(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            if (entry == null) {
                return null;
            }
            NodeQuery query = this.getQuery();
            String revision = query.getRevision();
            if (!entry.satisfiesRevision(revision)) {
                this.logDecision(ResolverDecisionType.REVISION_REJECTED, Long.valueOf(entry.getRevision()), Messages.Too_high);
                return null;
            }
            Date timestamp = query.getTimestamp();
            if (timestamp != null && (entryTs = entry.getTimestamp()) != null && entryTs.compareTo(timestamp) > 0) {
                this.logDecision(ResolverDecisionType.TIMESTAMP_REJECTED, entryTs, Messages.Too_young);
                return null;
            }
            Version version = null;
            try {
                version = this.getVersionFromArtifacts(null, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            }
            catch (CoreException e) {
                this.logDecision(ResolverDecisionType.MAIN_REJECTED, e.getMessage());
                monitor.done();
                return null;
            }
            VersionRange versionDesignator = query.getVersionRange();
            if (versionDesignator != null && !versionDesignator.isIncluded(version)) {
                this.logDecision(ResolverDecisionType.VERSION_REJECTED, version, NLS.bind((String)Messages.Not_designated_by_0, (Object)versionDesignator));
                return null;
            }
            VersionMatch versionMatch = new VersionMatch(version, null, entry.getRevision(), entry.getTimestamp(), null);
            return versionMatch;
        }
        finally {
            monitor.done();
        }
    }

    protected abstract List<RevisionEntry> getBranchesOrTags(boolean var1, IProgressMonitor var2) throws CoreException;

    protected abstract RevisionEntry getTrunk(IProgressMonitor var1) throws CoreException;

    protected static class RevisionEntry {
        private final String entryName;
        private final String revision;
        private final Date timestamp;

        public RevisionEntry(String entryName, Date timestamp, long revision) {
            this.entryName = entryName;
            this.timestamp = timestamp;
            this.revision = revision == -1L ? null : Long.toString(revision);
        }

        public RevisionEntry(String entryName, Date timestamp, String revision) {
            this.entryName = entryName;
            this.timestamp = timestamp;
            this.revision = revision;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public String getRevision() {
            return this.revision;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public boolean satisfiesRevision(String rev) {
            return VersionMatch.satisfiesRevision(rev, this.revision);
        }
    }
}

