/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.rmap.impl;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.model.common.ComponentIdentifier;
import org.eclipse.buckminster.model.common.ComponentName;
import org.eclipse.buckminster.model.common.Documentation;
import org.eclipse.buckminster.model.common.Format;
import org.eclipse.buckminster.model.common.impl.PropertiesImpl;
import org.eclipse.buckminster.model.common.util.MapUnion;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.rmap.Matcher;
import org.eclipse.buckminster.rmap.Provider;
import org.eclipse.buckminster.rmap.Repository;
import org.eclipse.buckminster.rmap.ResourceMap;
import org.eclipse.buckminster.rmap.RmapPackage;
import org.eclipse.buckminster.rmap.SearchPath;
import org.eclipse.buckminster.rmap.URIMatcher;
import org.eclipse.buckminster.rmap.VersionConverter;
import org.eclipse.buckminster.rmap.impl.MatcherImpl;
import org.eclipse.buckminster.rmap.impl.ResourceMapImpl;
import org.eclipse.buckminster.rmap.util.IComponentReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;

public class ProviderImpl
extends PropertiesImpl
implements Provider {
    protected static final Pattern PATTERN_EDEFAULT = null;
    protected Pattern pattern = PATTERN_EDEFAULT;
    protected static final String COMPONENT_TYPES_ATTR_EDEFAULT = null;
    protected EList<String> componentTypes;
    protected static final Filter RESOLUTION_FILTER_EDEFAULT = null;
    protected Filter resolutionFilter = RESOLUTION_FILTER_EDEFAULT;
    protected static final String READER_TYPE_EDEFAULT = null;
    protected String readerType = READER_TYPE_EDEFAULT;
    protected static final boolean SOURCE_EDEFAULT = true;
    protected static final boolean MUTABLE_EDEFAULT = true;
    protected Repository repository;
    protected VersionConverter versionConverter;
    protected Format uri;
    protected URIMatcher matcher;
    protected Documentation documentation;

    protected ProviderImpl() {
    }

    public Repository basicGetRepository() {
        return this.repository;
    }

    public NotificationChain basicSetDocumentation(Documentation newDocumentation, NotificationChain msgs) {
        Documentation oldDocumentation = this.documentation;
        this.documentation = newDocumentation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldDocumentation, (Object)newDocumentation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public NotificationChain basicSetMatcher(URIMatcher newMatcher, NotificationChain msgs) {
        URIMatcher oldMatcher = this.matcher;
        this.matcher = newMatcher;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldMatcher, (Object)newMatcher);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public NotificationChain basicSetURI(Format newURI, NotificationChain msgs) {
        Format oldURI = this.uri;
        this.uri = newURI;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldURI, (Object)newURI);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public NotificationChain basicSetVersionConverter(VersionConverter newVersionConverter, NotificationChain msgs) {
        VersionConverter oldVersionConverter = this.versionConverter;
        this.versionConverter = newVersionConverter;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldVersionConverter, (Object)newVersionConverter);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == Matcher.class) {
            switch (derivedFeatureID) {
                case 2: {
                    return 0;
                }
                case 3: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
                case 5: {
                    return 3;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == Matcher.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
                case 3: {
                    return 5;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getPattern();
            }
            case 3: {
                return this.getComponentTypesAttr();
            }
            case 4: {
                return this.getComponentTypes();
            }
            case 5: {
                return this.getResolutionFilter();
            }
            case 6: {
                return this.getReaderType();
            }
            case 7: {
                return this.isSource();
            }
            case 8: {
                return this.isMutable();
            }
            case 9: {
                if (resolve) {
                    return this.getRepository();
                }
                return this.basicGetRepository();
            }
            case 10: {
                return this.getVersionConverter();
            }
            case 11: {
                return this.getURI();
            }
            case 12: {
                return this.getMatcher();
            }
            case 13: {
                return this.getDocumentation();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 10: {
                return this.basicSetVersionConverter(null, msgs);
            }
            case 11: {
                return this.basicSetURI(null, msgs);
            }
            case 12: {
                return this.basicSetMatcher(null, msgs);
            }
            case 13: {
                return this.basicSetDocumentation(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return PATTERN_EDEFAULT == null ? this.pattern != null : !PATTERN_EDEFAULT.equals(this.pattern);
            }
            case 3: {
                return COMPONENT_TYPES_ATTR_EDEFAULT == null ? this.getComponentTypesAttr() != null : !COMPONENT_TYPES_ATTR_EDEFAULT.equals(this.getComponentTypesAttr());
            }
            case 4: {
                return this.componentTypes != null && !this.componentTypes.isEmpty();
            }
            case 5: {
                return RESOLUTION_FILTER_EDEFAULT == null ? this.resolutionFilter != null : !RESOLUTION_FILTER_EDEFAULT.equals((Object)this.resolutionFilter);
            }
            case 6: {
                return READER_TYPE_EDEFAULT == null ? this.readerType != null : !READER_TYPE_EDEFAULT.equals(this.readerType);
            }
            case 7: {
                return !this.isSource();
            }
            case 8: {
                return !this.isMutable();
            }
            case 9: {
                return this.repository != null;
            }
            case 10: {
                return this.versionConverter != null;
            }
            case 11: {
                return this.uri != null;
            }
            case 12: {
                return this.matcher != null;
            }
            case 13: {
                return this.documentation != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setPattern((Pattern)newValue);
                return;
            }
            case 3: {
                this.setComponentTypesAttr((String)newValue);
                return;
            }
            case 4: {
                this.getComponentTypes().clear();
                this.getComponentTypes().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setResolutionFilter((Filter)newValue);
                return;
            }
            case 6: {
                this.setReaderType((String)newValue);
                return;
            }
            case 7: {
                this.setSource((Boolean)newValue);
                return;
            }
            case 8: {
                this.setMutable((Boolean)newValue);
                return;
            }
            case 9: {
                this.setRepository((Repository)newValue);
                return;
            }
            case 10: {
                this.setVersionConverter((VersionConverter)newValue);
                return;
            }
            case 11: {
                this.setURI((Format)newValue);
                return;
            }
            case 12: {
                this.setMatcher((URIMatcher)newValue);
                return;
            }
            case 13: {
                this.setDocumentation((Documentation)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setPattern(PATTERN_EDEFAULT);
                return;
            }
            case 3: {
                this.setComponentTypesAttr(COMPONENT_TYPES_ATTR_EDEFAULT);
                return;
            }
            case 4: {
                this.getComponentTypes().clear();
                return;
            }
            case 5: {
                this.setResolutionFilter(RESOLUTION_FILTER_EDEFAULT);
                return;
            }
            case 6: {
                this.setReaderType(READER_TYPE_EDEFAULT);
                return;
            }
            case 7: {
                this.setSource(true);
                return;
            }
            case 8: {
                this.setMutable(true);
                return;
            }
            case 9: {
                this.setRepository(null);
                return;
            }
            case 10: {
                this.setVersionConverter(null);
                return;
            }
            case 11: {
                this.setURI(null);
                return;
            }
            case 12: {
                this.setMatcher(null);
                return;
            }
            case 13: {
                this.setDocumentation(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public EList<String> getComponentTypes() {
        if (this.componentTypes == null) {
            this.componentTypes = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 4);
        }
        return this.componentTypes;
    }

    @Override
    public String getComponentTypesAttr() {
        return MatcherImpl.getComponentTypesAttr(this);
    }

    @Override
    public ResourceMap getDelegationMap(IComponentReader reader, IStatus problemCollector, Map<ComponentIdentifier, Map<String, String>> queryHints, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Documentation getDocumentation() {
        return this.documentation;
    }

    @Override
    public URIMatcher getMatcher() {
        return this.matcher;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public Map<String, String> getProperties(Map<String, String> properties) {
        ResourceMap rmap;
        Map myProps = this.getProperties();
        if (myProps.size() > 0) {
            properties = new MapUnion(properties, myProps);
        }
        if ((rmap = this.getResourceMap()) != null) {
            properties = ((ResourceMapImpl)rmap).getProperties((Map<String, String>)properties);
        }
        return properties;
    }

    @Override
    public String getReaderType() {
        return this.readerType;
    }

    @Override
    public Repository getRepository() {
        if (this.repository != null && this.repository.eIsProxy()) {
            InternalEObject oldRepository = (InternalEObject)this.repository;
            this.repository = (Repository)this.eResolveProxy(oldRepository);
            if (this.repository != oldRepository && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 9, (Object)oldRepository, (Object)this.repository));
            }
        }
        return this.repository;
    }

    @Override
    public Filter getResolutionFilter() {
        return this.resolutionFilter;
    }

    @Override
    public ResourceMap getResourceMap() {
        EObject c = this.eContainer();
        if (c instanceof SearchPath) {
            c = c.eContainer();
        }
        return (ResourceMap)c;
    }

    @Override
    public Format getURI() {
        return this.uri;
    }

    @Override
    public String getURI(Map<String, String> properties) {
        return this.getURI().getValue(this.getProperties(properties));
    }

    @Override
    public VersionConverter getVersionConverter() {
        return this.versionConverter;
    }

    @Override
    public boolean hasDelegationMap() {
        return false;
    }

    @Override
    public boolean isMutable() {
        String tmp = (String)this.getProperties().get("buckminster.mutable");
        return tmp == null ? true : Boolean.valueOf(tmp);
    }

    @Override
    public boolean isSource() {
        String tmp = (String)this.getProperties().get("buckminster.source");
        return tmp == null ? true : Boolean.valueOf(tmp);
    }

    @Override
    public boolean matches(ComponentName componentName, Map<String, String> properties) {
        return MatcherImpl.matches(this, componentName, properties);
    }

    @Override
    public void setComponentTypesAttr(String newComponentTypesAttr) {
        MatcherImpl.setComponentTypesAttr(this, newComponentTypesAttr);
    }

    @Override
    public void setDocumentation(Documentation newDocumentation) {
        if (newDocumentation != this.documentation) {
            NotificationChain msgs = null;
            if (this.documentation != null) {
                msgs = ((InternalEObject)this.documentation).eInverseRemove((InternalEObject)this, -14, null, msgs);
            }
            if (newDocumentation != null) {
                msgs = ((InternalEObject)newDocumentation).eInverseAdd((InternalEObject)this, -14, null, msgs);
            }
            if ((msgs = this.basicSetDocumentation(newDocumentation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)newDocumentation, (Object)newDocumentation));
        }
    }

    @Override
    public void setMatcher(URIMatcher newMatcher) {
        if (newMatcher != this.matcher) {
            NotificationChain msgs = null;
            if (this.matcher != null) {
                msgs = ((InternalEObject)this.matcher).eInverseRemove((InternalEObject)this, -13, null, msgs);
            }
            if (newMatcher != null) {
                msgs = ((InternalEObject)newMatcher).eInverseAdd((InternalEObject)this, -13, null, msgs);
            }
            if ((msgs = this.basicSetMatcher(newMatcher, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)newMatcher, (Object)newMatcher));
        }
    }

    @Override
    public void setMutable(boolean mutable) {
        Map props = this.getProperties();
        if (mutable) {
            props.remove("buckminster.mutable");
        } else {
            props.put("buckminster.mutable", String.valueOf(mutable));
        }
    }

    @Override
    public void setPattern(Pattern newPattern) {
        Pattern oldPattern = this.pattern;
        this.pattern = newPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldPattern, (Object)this.pattern));
        }
    }

    @Override
    public void setReaderType(String newReaderType) {
        String oldReaderType = this.readerType;
        this.readerType = newReaderType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldReaderType, (Object)this.readerType));
        }
    }

    @Override
    public void setRepository(Repository newRepository) {
        Repository oldRepository = this.repository;
        this.repository = newRepository;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldRepository, (Object)this.repository));
        }
    }

    @Override
    public void setResolutionFilter(Filter newResolutionFilter) {
        Filter oldResolutionFilter = this.resolutionFilter;
        this.resolutionFilter = newResolutionFilter;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldResolutionFilter, (Object)this.resolutionFilter));
        }
    }

    @Override
    public void setSource(boolean source) {
        Map props = this.getProperties();
        if (source) {
            props.remove("buckminster.source");
        } else {
            props.put("buckminster.source", String.valueOf(source));
        }
    }

    @Override
    public void setURI(Format newURI) {
        if (newURI != this.uri) {
            NotificationChain msgs = null;
            if (this.uri != null) {
                msgs = ((InternalEObject)this.uri).eInverseRemove((InternalEObject)this, -12, null, msgs);
            }
            if (newURI != null) {
                msgs = ((InternalEObject)newURI).eInverseAdd((InternalEObject)this, -12, null, msgs);
            }
            if ((msgs = this.basicSetURI(newURI, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)newURI, (Object)newURI));
        }
    }

    @Override
    public void setVersionConverter(VersionConverter newVersionConverter) {
        if (newVersionConverter != this.versionConverter) {
            NotificationChain msgs = null;
            if (this.versionConverter != null) {
                msgs = ((InternalEObject)this.versionConverter).eInverseRemove((InternalEObject)this, -11, null, msgs);
            }
            if (newVersionConverter != null) {
                msgs = ((InternalEObject)newVersionConverter).eInverseAdd((InternalEObject)this, -11, null, msgs);
            }
            if ((msgs = this.basicSetVersionConverter(newVersionConverter, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)newVersionConverter, (Object)newVersionConverter));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (pattern: ");
        result.append(this.pattern);
        result.append(", componentTypes: ");
        result.append(this.componentTypes);
        result.append(", resolutionFilter: ");
        result.append(this.resolutionFilter);
        result.append(", readerType: ");
        result.append(this.readerType);
        result.append(')');
        return result.toString();
    }

    protected EClass eStaticClass() {
        return RmapPackage.Literals.PROVIDER;
    }
}

