/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.metadata.model.BOMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortesPathCalculation {
    private static final Integer VERY_LARGE_NUMBER = 1000000000;

    public static List<BOMNode> calculatePath(BOMNode root, BOMNode target) {
        LinkedList<BOMNode> queue = new LinkedList<BOMNode>();
        HashSet<BOMNode> nodes = new HashSet<BOMNode>();
        LinkedList<BOMNode> orderedList = new LinkedList<BOMNode>();
        queue.add(root);
        while (!queue.isEmpty()) {
            BOMNode head = (BOMNode)queue.remove(0);
            if (nodes.contains(head)) continue;
            nodes.add(head);
            orderedList.add(head);
            queue.addAll(head.getChildren());
        }
        List<BOMNode> path = ShortesPathCalculation.internalCalulcation(orderedList, root, target);
        return path;
    }

    private static Map<BOMNode, Integer> initializeLengthMap(List<BOMNode> queue, BOMNode root) {
        HashMap<BOMNode, Integer> map = new HashMap<BOMNode, Integer>();
        for (BOMNode bomNode : queue) {
            map.put(bomNode, VERY_LARGE_NUMBER);
            map.put(root, 0);
        }
        return map;
    }

    private static List<BOMNode> internalCalulcation(List<BOMNode> queue, BOMNode root, BOMNode target) {
        HashMap<BOMNode, BOMNode> previous = new HashMap<BOMNode, BOMNode>();
        Map<BOMNode, Integer> lengthMap = ShortesPathCalculation.initializeLengthMap(queue, root);
        while (!queue.isEmpty()) {
            BOMNode head = queue.remove(0);
            List outgoing = head.getChildren();
            for (BOMNode current : outgoing) {
                int currentLength;
                int headLength = lengthMap.get(head);
                if (headLength + 1 >= (currentLength = lengthMap.get(current).intValue())) continue;
                previous.put(current, head);
                lengthMap.put(current, headLength + 1);
            }
        }
        ArrayList<BOMNode> path = new ArrayList<BOMNode>(previous.size());
        while (previous.containsKey(target)) {
            path.add(target);
            target = (BOMNode)previous.get(target);
        }
        path.add(target);
        return path;
    }
}

