/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.actions;

import java.util.List;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.internal.DynamicTableLayout;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractChosenCSpecAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void dispose() {
    }

    public void init(IWorkbenchWindow w) {
        this.window = w;
    }

    public void run(IAction action) {
        Shell shell = this.window.getShell();
        try {
            ComponentsDialog dialog = new ComponentsDialog(shell, Messages.components_known_to_buckminster, WorkspaceInfo.getAllResolutions());
            if (dialog.open() != 0) {
                return;
            }
            Resolution cinfo = dialog.getSelectedComponent();
            if (cinfo != null) {
                this.run(cinfo.getCSpec(), this.window);
            }
        }
        catch (Exception e) {
            UiUtils.openError(shell, Messages.errors_during_loading, e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected abstract void run(CSpec var1, IWorkbenchWindow var2);

    static class ComponentLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ComponentLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String lbl;
            Resolution cr = (Resolution)element;
            switch (columnIndex) {
                case 0: {
                    lbl = cr.getRequest().getViewName();
                    break;
                }
                case 1: {
                    lbl = VersionHelper.getHumanReadable((Version)cr.getVersion());
                    break;
                }
                default: {
                    lbl = null;
                }
            }
            return lbl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComponentsDialog
    extends Dialog {
        private final List<Resolution> resolutions;
        private Resolution selectedComponent;
        private String title;
        private TableViewer viewer;

        ComponentsDialog(Shell parentShell, String title, List<Resolution> resolutions) {
            super(parentShell);
            this.title = title;
            this.resolutions = resolutions;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(this.title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite superArea = (Composite)super.createDialogArea(parent);
            Table table = new Table(superArea, 2820);
            String[] columnNames = new String[]{Messages.name, Messages.version};
            int[] columnWeights = new int[]{70, 30};
            table.setHeaderVisible(true);
            DynamicTableLayout layout = new DynamicTableLayout(450);
            int idx = 0;
            while (idx < columnNames.length) {
                TableColumn tableColumn = new TableColumn(table, 16384, idx);
                tableColumn.setText(columnNames[idx]);
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(columnWeights[idx], true));
                ++idx;
            }
            table.setLayout((Layout)layout);
            table.setSize(450, 450);
            table.setLayoutData((Object)new GridData(4, 4, true, true));
            this.viewer = new TableViewer(table);
            this.viewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
            this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ComponentsDialog.this.getButton(0).setEnabled(selection.size() == 1);
                }
            });
            List<Resolution> input = this.resolutions.size() > 15 ? this.resolutions.subList(0, 15) : this.resolutions;
            this.viewer.setInput(input);
            return superArea;
        }

        protected void initializeBounds() {
            super.initializeBounds();
            this.viewer.setInput(this.resolutions);
            ((Table)this.viewer.getControl()).select(0);
        }

        protected void okPressed() {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection.size() == 1) {
                this.selectedComponent = (Resolution)selection.getFirstElement();
                super.okPressed();
            }
        }

        Resolution getSelectedComponent() {
            return this.selectedComponent;
        }
    }
}

