/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.providers;

import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.model.Group;
import org.eclipse.buckminster.core.metadata.IResolution;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.generic.model.tree.BasicTreeParentDataNode;
import org.eclipse.buckminster.generic.model.tree.ITreeDataNode;
import org.eclipse.buckminster.generic.ui.utils.UiUtils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiPlugin;
import org.eclipse.buckminster.ui.adapters.ComponentReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class BuckminsterLabelProvider
extends ColumnLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private Image projectImage;
    private Image folderImage;
    private Image fileImage;
    private Image cspecImage;
    private Image componentImage;
    private Image dependantImage;
    private Image dependencyImage;
    private Image groupImage;
    private Image actionImage;

    public void dispose() {
        if (this.projectImage != null) {
            this.projectImage.dispose();
        }
        if (this.folderImage != null) {
            this.folderImage.dispose();
        }
        if (this.fileImage != null) {
            this.fileImage.dispose();
        }
        if (this.cspecImage != null) {
            this.cspecImage.dispose();
        }
        if (this.componentImage != null) {
            this.componentImage.dispose();
        }
        if (this.dependencyImage != null) {
            this.dependencyImage.dispose();
        }
        if (this.dependantImage != null) {
            this.dependantImage.dispose();
        }
        if (this.groupImage != null) {
            this.groupImage.dispose();
        }
        if (this.actionImage != null) {
            this.actionImage.dispose();
        }
        super.dispose();
    }

    public Image getImage(Object selected) {
        Attribute attribute;
        Object element = selected;
        if (selected instanceof ITreeDataNode) {
            element = ((ITreeDataNode)element).getData();
        }
        if (element instanceof IProject) {
            return this.getProjectImage();
        }
        if (element instanceof IFolder) {
            return this.getFolderImage();
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            ImageDescriptor imageDescriptor = UiUtils.getImageDescriptor((IFile)file);
            return imageDescriptor == null ? this.getFileImage() : UiUtils.getImage((ImageDescriptor)imageDescriptor);
        }
        if (element instanceof ICSpecData) {
            return this.getCspecImage();
        }
        if (element instanceof IResolution) {
            return this.getComponentImage();
        }
        if (element instanceof ComponentReference) {
            return ((ComponentReference)element).getMode() == ComponentReference.Mode.IN ? this.getDependantImage() : this.getDependencyImage();
        }
        if (element instanceof Attribute && (attribute = (Attribute)element).isPublic()) {
            if (attribute instanceof Group) {
                return this.getGroupImage();
            }
            return this.getActionImage();
        }
        if (selected instanceof BasicTreeParentDataNode) {
            return this.getFolderImage();
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof ITreeDataNode) {
            element = ((ITreeDataNode)element).getData();
        }
        if (element instanceof IResource) {
            return new StyledString(((IResource)element).getName());
        }
        if (element instanceof IResolution) {
            Version version;
            Resolution r = (Resolution)element;
            StyledString bld = new StyledString(r.getName());
            String type = r.getComponentTypeId();
            if (type != null) {
                bld.append(" : ", StyledString.DECORATIONS_STYLER);
                bld.append(type, StyledString.DECORATIONS_STYLER);
            }
            if ((version = r.getVersion()) != null) {
                bld.append(" - ", StyledString.DECORATIONS_STYLER);
                bld.append(VersionHelper.getHumanReadable((Version)version), StyledString.DECORATIONS_STYLER);
            }
            return bld;
        }
        if (element instanceof ComponentReference) {
            ComponentReference ref = (ComponentReference)element;
            StyledString bld = new StyledString(ref.getComponentName());
            ComponentRequest req = ref.getComponentRequest();
            if (req.getComponentTypeID() != null) {
                bld.append(" : ", StyledString.DECORATIONS_STYLER);
                bld.append(req.getComponentTypeID(), StyledString.DECORATIONS_STYLER);
            }
            if (req.getVersionRange() != null) {
                bld.append(" - ", StyledString.DECORATIONS_STYLER);
                bld.append(req.getVersionRange().toString(), StyledString.DECORATIONS_STYLER);
            }
            return bld;
        }
        if (element instanceof Attribute) {
            Attribute attr = (Attribute)element;
            StyledString bld = new StyledString(attr.getName());
            return bld;
        }
        if (element instanceof ICSpecData) {
            return new StyledString(Messages.component_specification_and_cspec_in_paranthesis);
        }
        return new StyledString(element.toString());
    }

    public String getText(Object element) {
        return this.getStyledText(element).toString();
    }

    private Image getActionImage() {
        if (this.actionImage == null) {
            this.actionImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)UiPlugin.getID(), (String)"icons/action.gif").createImage();
        }
        return this.actionImage;
    }

    private Image getComponentImage() {
        if (this.componentImage == null) {
            this.componentImage = UiPlugin.getImageDescriptor("icons/component.png").createImage();
        }
        return this.componentImage;
    }

    private Image getCspecImage() {
        if (this.cspecImage == null) {
            this.cspecImage = UiPlugin.getImageDescriptor("icons/cspec.png").createImage();
        }
        return this.cspecImage;
    }

    private Image getDependantImage() {
        if (this.dependantImage == null) {
            this.dependantImage = UiPlugin.getImageDescriptor("icons/dependent.png").createImage();
        }
        return this.dependantImage;
    }

    private Image getDependencyImage() {
        if (this.dependencyImage == null) {
            this.dependencyImage = UiPlugin.getImageDescriptor("icons/dependency.png").createImage();
        }
        return this.dependencyImage;
    }

    private Image getFileImage() {
        if (this.fileImage == null) {
            this.fileImage = UiPlugin.getImageDescriptor("icons/file_obj.gif").createImage();
        }
        return this.fileImage;
    }

    private Image getFolderImage() {
        if (this.folderImage == null) {
            this.folderImage = UiPlugin.getImageDescriptor("icons/fldr_obj.gif").createImage();
        }
        return this.folderImage;
    }

    private Image getProjectImage() {
        if (this.projectImage == null) {
            this.projectImage = UiPlugin.getImageDescriptor("icons/prj_obj.gif").createImage();
        }
        return this.projectImage;
    }

    private Image getGroupImage() {
        if (this.groupImage == null) {
            this.groupImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)UiPlugin.getID(), (String)"icons/group.gif").createImage();
        }
        return this.groupImage;
    }
}

