/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.cspec.IComponentName;
import org.eclipse.buckminster.core.cspec.model.NamedElement;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentName
extends NamedElement
implements Comparable<IComponentName>,
IComponentName {
    public static final String TAG = "componentName";
    public static final String ATTR_COMPONENT_TYPE = "componentType";
    private final String componentType;

    public ComponentName(String name, String componentType) {
        super(name);
        this.componentType = componentType;
    }

    ComponentName(ComponentName other) {
        super(other.getName());
        this.componentType = other.getComponentTypeID();
    }

    @Override
    public int compareTo(IComponentName o) {
        int cmp = Trivial.compareAllowNull((Comparable)((Object)this.getName()), (Comparable)((Object)o.getName()));
        if (cmp == 0) {
            cmp = Trivial.compareAllowNull((Comparable)((Object)this.componentType), (Comparable)((Object)o.getComponentTypeID()));
        }
        return cmp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComponentName)) {
            return false;
        }
        ComponentName that = (ComponentName)o;
        return Trivial.equalsAllowNull((Object)this.getName(), (Object)that.getName()) && Trivial.equalsAllowNull((Object)this.componentType, (Object)that.componentType);
    }

    public IComponentType getComponentType() throws CoreException {
        return this.componentType == null ? null : CorePlugin.getDefault().getComponentType(this.componentType);
    }

    @Override
    public String getComponentTypeID() {
        return this.componentType;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public String getProjectName() throws CoreException {
        String name = this.getName();
        IComponentType ctype = this.getComponentType();
        if (name == null || ctype == null) {
            return name;
        }
        return ctype.getProjectName(name);
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> p = new HashMap<String, String>();
        if (this.getName() != null) {
            p.put("buckminster.component", this.getName());
        }
        if (this.componentType != null) {
            p.put("buckminster.component.type", this.componentType);
        }
        return p;
    }

    public int hashCode() {
        int hc;
        int n = hc = this.getName() == null ? 31 : this.getName().hashCode();
        if (this.componentType != null) {
            hc *= 37;
            hc += this.componentType.hashCode();
        }
        return hc;
    }

    public boolean matches(ComponentName o) {
        return Trivial.equalsAllowNull((Object)this.getName(), (Object)o.getName()) && (this.componentType == null || o.componentType == null || this.componentType.equals(o.componentType));
    }

    public IComponentName toPureComponentName() {
        return this;
    }

    @Override
    public final String toString() {
        StringBuilder bld = new StringBuilder();
        this.toString(bld);
        return bld.toString();
    }

    public void toString(StringBuilder bld) {
        bld.append(this.getName());
        if (this.componentType != null) {
            bld.append(':');
            bld.append(this.componentType);
        }
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        if (this.componentType != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT_TYPE, (String)this.componentType);
        }
    }
}

