/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.actor;

import java.io.PrintStream;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.osgi.util.NLS;

public class LaunchActor
extends AbstractActor {
    public static final String ID = "launch";
    private static final String LAUNCHER_PATH = "path";
    private static final String LAUNCHER_MODE = "mode";

    private IPath getLaunchConfigurationPath() throws CoreException {
        String path = Trivial.trim((String)this.getActorProperty(LAUNCHER_PATH));
        if (path == null) {
            throw BuckminsterException.fromMessage((String)Messages.Launch_No_launch_config, (Object[])new Object[0]);
        }
        return Path.fromPortableString((String)path);
    }

    protected String getLaunchMode() {
        String mode = Trivial.trim((String)this.getActorProperty(LAUNCHER_MODE));
        return mode == null ? "run" : mode;
    }

    protected IStatus internalPerform(IActionContext ctx, IProgressMonitor monitor) throws CoreException {
        IProject project = ctx.getProject();
        IFile launchFile = null;
        IPath launchConfigPath = this.getLaunchConfigurationPath();
        if (project != null && project.isAccessible()) {
            launchFile = project.getFile(launchConfigPath);
        }
        if (launchFile == null || !launchFile.exists()) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Launch_Cannot_open_launch_config, (Object)launchConfigPath.toPortableString()), (Object[])new Object[0]);
        }
        ILaunch launch = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(launchFile).launch(this.getLaunchMode(), monitor);
        IProcess[] processes = launch.getProcesses();
        StreamDispatcher out = new StreamDispatcher(ctx.getOutputStream());
        StreamDispatcher err = new StreamDispatcher(ctx.getErrorStream());
        IProcess[] iProcessArray = processes;
        int n = processes.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess p = iProcessArray[n2];
            IStreamsProxy streamsProxy = p.getStreamsProxy();
            if (streamsProxy != null) {
                IStreamMonitor errMon;
                IStreamMonitor outMon = streamsProxy.getOutputStreamMonitor();
                if (outMon != null) {
                    outMon.addListener((IStreamListener)out);
                }
                if ((errMon = streamsProxy.getErrorStreamMonitor()) != null) {
                    errMon.addListener((IStreamListener)err);
                }
            }
            ++n2;
        }
        try {
            while (!launch.isTerminated()) {
                if (monitor.isCanceled() && launch.canTerminate()) {
                    launch.terminate();
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException();
        }
        MultiStatus result = new MultiStatus(CorePlugin.getID(), 0, "launch problem", null);
        IProcess[] iProcessArray2 = processes;
        int n3 = processes.length;
        n = 0;
        while (n < n3) {
            IProcess p = iProcessArray2[n];
            if (p.getExitValue() != 0) {
                result.add((IStatus)new Status(4, CorePlugin.getID(), NLS.bind((String)Messages.Launch_Terminated_with_exit_status, (Object)p.getLabel(), (Object)p.getExitValue())));
            }
            ++n;
        }
        project.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        return result;
    }

    static class StreamDispatcher
    implements IStreamListener {
        private final PrintStream stream;

        StreamDispatcher(PrintStream stream) {
            this.stream = stream;
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.stream.print(text);
        }
    }
}

