/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.builder.MaterializationSpecBuilder;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.reader.ReferenceInfo;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.version.AbstractVersionFinder;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReaderType
extends AbstractExtension
implements IReaderType {
    public static IReaderType getTypeForRepositoryProvider(String providerId) throws CoreException {
        IExtensionRegistry exReg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = exReg.getConfigurationElementsFor("org.eclipse.buckminster.core.readerTypes");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (providerId.equals(elem.getAttribute("teamRepositoryId"))) {
                return CorePlugin.getDefault().getReaderType(elem.getAttribute("id"));
            }
            ++n2;
        }
        return null;
    }

    public static IReaderType getTypeForResource(IResource resource) throws CoreException {
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
        if (provider == null) {
            return null;
        }
        return AbstractReaderType.getTypeForRepositoryProvider(provider.getID());
    }

    @Override
    public void addMaterializationNode(MaterializationSpecBuilder bld, Resolution res) throws CoreException {
    }

    @Override
    public String convertFetchFactoryLocator(Map<String, Object> fetchFactoryLocator, String componentName) throws CoreException {
        throw new UnsupportedOperationException(NLS.bind((String)Messages.ReaderType_0_cannot_handle_fetchFactory_data, (Object)this.getId()));
    }

    @Override
    public URL convertToURL(String repositoryLocator, VersionMatch versionSelector) throws CoreException {
        return null;
    }

    @Override
    public ReferenceInfo extractReferenceInfo(String reference) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public VersionMatch getDefaultVersion() throws CoreException {
        return VersionMatch.DEFAULT;
    }

    @Override
    public IPath getFixedLocation(Resolution cr) throws CoreException {
        return null;
    }

    @Override
    public IPath getInstallLocation(Resolution resolution, MaterializationContext context) throws CoreException {
        return null;
    }

    @Override
    public Date getLastModification(File workingCopy, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    @Override
    public Date getLastModification(String repositoryLocation, VersionSelector versionSelector, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    @Override
    public long getLastRevision(File workingCopy, IProgressMonitor monitor) throws CoreException {
        return -1L;
    }

    @Override
    public long getLastRevision(String repositoryLocation, VersionSelector versionSelector, IProgressMonitor monitor) throws CoreException {
        return -1L;
    }

    @Override
    public IReaderType getLocalReaderType(boolean destIsFile) throws CoreException {
        return CorePlugin.getDefault().getReaderType(destIsFile ? "url" : "url.catalog");
    }

    @Override
    public IComponentReader getReader(Provider provider, IComponentType ctype, NodeQuery query, VersionMatch versionMatch, IProgressMonitor monitor) throws CoreException {
        return this.getReader(new ProviderMatch(provider, ctype, versionMatch, ProviderScore.FAIR, query), monitor);
    }

    @Override
    public IComponentReader getReader(Resolution cr, RMContext context, IProgressMonitor monitor) throws CoreException {
        return this.getReader(cr.getProviderMatch(context), monitor);
    }

    @Override
    public String getRecommendedMaterializer() {
        return "workspace";
    }

    @Override
    public String getRemoteLocation(File workingCopy, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    @Override
    public String getRemotePath(String repositoryLocation) throws CoreException {
        return null;
    }

    @Override
    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery query, IProgressMonitor monitor) throws CoreException {
        return new DefaultVersionFinder(provider, ctype, query);
    }

    @Override
    public void postMaterialization(MaterializationContext context, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void prepareMaterialization(List<Materialization> mtr, MaterializationContext context, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void shareProject(IProject project, Resolution cr, RMContext context, IProgressMonitor monitor) throws CoreException {
    }

    protected class DefaultVersionFinder
    extends AbstractVersionFinder {
        private final VersionMatch versionMatch;

        DefaultVersionFinder(Provider provider, IComponentType ctype, NodeQuery query) {
            super(provider, ctype, query);
            this.versionMatch = new VersionMatch(null, null, -1L, null, null);
        }

        public VersionMatch getBestVersion(IProgressMonitor monitor) throws CoreException {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return this.versionMatch;
        }
    }
}

