/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.buckminster.core.version.MissingVersionTypeException;
import org.eclipse.buckminster.core.version.VersionType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.eclipse.equinox.p2.metadata.VersionFormatException;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionHelper {
    private static final org.eclipse.equinox.p2.metadata.Version sampleOSGiVersion;
    static final String VERSION_TYPES_POINT = "org.eclipse.buckminster.core.versionTypes";
    private static final HashMap<String, VersionType> knownTypes;
    private static SimpleDateFormat timestampFormat;
    private static SimpleDateFormat dateFormat;

    static {
        knownTypes = new HashMap();
        timestampFormat = new SimpleDateFormat("yyyyMMdd'.'HHmmss");
        dateFormat = new SimpleDateFormat("yyyyMMdd");
        try {
            sampleOSGiVersion = org.eclipse.equinox.p2.metadata.Version.parseVersion((String)"1.0.0");
            IVersionFormat osgiFormat = sampleOSGiVersion.getFormat();
            VersionType osgiType = new VersionType(osgiFormat, "OSGi");
            String osgiFmtString = osgiFormat.toString();
            osgiFmtString = osgiFmtString.substring(7, osgiFmtString.length() - 1);
            knownTypes.put(osgiFmtString, osgiType);
            if (!osgiFmtString.equals("n[.n=0;[.n=0;[.S='';=[A-Za-z0-9_-];]]]")) {
                knownTypes.put("n[.n=0;[.n=0;[.S='';=[A-Za-z0-9_-];]]]", osgiType);
            }
            IExtensionRegistry exReg = Platform.getExtensionRegistry();
            IConfigurationElement[] elems = exReg.getConfigurationElementsFor(VERSION_TYPES_POINT);
            int idx = elems.length;
            block2: while (--idx >= 0) {
                VersionType vt;
                IConfigurationElement elem = elems[idx];
                String format = elem.getAttribute("format");
                String id = elem.getAttribute("id");
                VersionType versionType = vt = "OSGi".equals(id) ? osgiType : knownTypes.get(format);
                if (vt != null) {
                    String[] labels = vt.getLabels();
                    int top = labels.length;
                    int ldx = 0;
                    while (ldx < top) {
                        if (labels[ldx].equals(id)) continue block2;
                        ++ldx;
                    }
                    String[] newLabels = new String[top + 1];
                    System.arraycopy(labels, 0, newLabels, 0, top);
                    newLabels[top] = id;
                    vt = new VersionType(vt.getFormat(), newLabels);
                } else {
                    vt = new VersionType(org.eclipse.equinox.p2.metadata.Version.compile((String)format), id);
                }
                knownTypes.put(format, vt);
            }
        }
        catch (VersionFormatException e) {
            throw new ExceptionInInitializerError(e);
        }
        TimeZone utc = TimeZone.getTimeZone("UTC");
        timestampFormat.setTimeZone(utc);
        dateFormat.setTimeZone(utc);
    }

    public static VersionRange createRange(IVersionFormat versionFormat, String rangeString) {
        if (rangeString == null) {
            return null;
        }
        if (versionFormat == null || versionFormat.equals(VersionHelper.getOSGiFormat())) {
            return new VersionRange(rangeString);
        }
        StringBuffer bld = new StringBuffer();
        versionFormat.toString(bld);
        bld.append(':');
        bld.append(rangeString);
        return new VersionRange(bld.toString());
    }

    public static VersionRange createRange(String versionTypeLabel, String rangeString) throws MissingVersionTypeException {
        return VersionHelper.createRange(VersionHelper.getVersionType(versionTypeLabel), rangeString);
    }

    public static VersionRange createRange(VersionType versionType, String rangeString) {
        return VersionHelper.createRange(versionType == null ? null : versionType.getFormat(), rangeString);
    }

    public static org.eclipse.equinox.p2.metadata.Version createVersion(IVersionFormat versionFormat, String versionString) {
        if (versionString == null) {
            return null;
        }
        if ((versionString = Trivial.trim((String)versionString)) == null) {
            return null;
        }
        if (versionFormat == null) {
            versionFormat = VersionHelper.getOSGiFormat();
        }
        return versionFormat.parse(versionString);
    }

    public static org.eclipse.equinox.p2.metadata.Version createVersion(String versionTypeLabel, String versionString) throws MissingVersionTypeException {
        return VersionHelper.createVersion(VersionHelper.getVersionType(versionTypeLabel), versionString);
    }

    public static org.eclipse.equinox.p2.metadata.Version createVersion(VersionType versionType, String versionString) {
        return VersionHelper.createVersion(versionType == null ? null : versionType.getFormat(), versionString);
    }

    public static boolean equalsUnqualified(org.eclipse.equinox.p2.metadata.Version a, org.eclipse.equinox.p2.metadata.Version b) {
        IVersionFormat bf;
        IVersionFormat af;
        if (a == null || a == org.eclipse.equinox.p2.metadata.Version.emptyVersion) {
            return b == null || b == org.eclipse.equinox.p2.metadata.Version.emptyVersion;
        }
        if (b == null || b == org.eclipse.equinox.p2.metadata.Version.emptyVersion) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        String aq = VersionHelper.getQualifier(a);
        String bq = VersionHelper.getQualifier(b);
        if (aq == null && bq == null) {
            return false;
        }
        String astr = VersionHelper.getOriginal(a);
        if (aq != null) {
            astr = astr.substring(0, astr.length() - (aq.length() + 1));
        }
        String bstr = VersionHelper.getOriginal(b);
        if (bq != null) {
            bstr = bstr.substring(0, bstr.length() - (bq.length() + 1));
        }
        if ((af = a.getFormat()) == null) {
            af = VersionHelper.getVersionType(null).getFormat();
        }
        if ((bf = a.getFormat()) == null) {
            bf = VersionHelper.getVersionType(null).getFormat();
        }
        return af.parse(astr).equals(bf.parse(bstr));
    }

    public static VersionRange exactRange(Version v) {
        return v == null ? null : VersionHelper.exactRange(org.eclipse.equinox.p2.metadata.Version.parseVersion((String)v.toString()));
    }

    public static VersionRange exactRange(org.eclipse.equinox.p2.metadata.Version v) {
        return v == null || v == org.eclipse.equinox.p2.metadata.Version.emptyVersion ? null : new VersionRange(v, true, v, true);
    }

    public static String getHumanReadable(org.eclipse.equinox.p2.metadata.Version version) {
        if (version == null || version == org.eclipse.equinox.p2.metadata.Version.emptyVersion) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        VersionHelper.getOriginal(version, buf);
        if (!VersionHelper.getOSGiFormat().equals(version.getFormat())) {
            buf.append('#');
            buf.append(VersionHelper.getVersionType(version).getId());
        }
        return buf.toString();
    }

    public static String getHumanReadable(VersionRange range) {
        if (range == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (VersionHelper.getOSGiFormat().equals(range.getFormat())) {
            range.toString(buf);
        } else {
            if (range.getMaximum().equals(org.eclipse.equinox.p2.metadata.Version.MAX_VERSION) && range.getIncludeMaximum()) {
                VersionHelper.getOriginal(range.getMinimum(), buf);
            } else {
                buf.append(range.getIncludeMinimum() ? (char)'[' : '(');
                VersionHelper.getOriginal(range.getMinimum(), buf);
                buf.append(',');
                VersionHelper.getOriginal(range.getMaximum(), buf);
                buf.append(range.getIncludeMaximum() ? (char)']' : ')');
            }
            buf.append('#');
            buf.append(VersionHelper.getVersionType(range).getId());
        }
        return buf.toString();
    }

    public static List<VersionType> getKnownTypes() {
        ArrayList<VersionType> knownTypeLists = new ArrayList<VersionType>(knownTypes.values());
        Collections.sort(knownTypeLists, new Comparator<VersionType>(){

            @Override
            public int compare(VersionType o1, VersionType o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        return knownTypeLists;
    }

    public static String getOriginal(org.eclipse.equinox.p2.metadata.Version version) {
        if (version == null || version == org.eclipse.equinox.p2.metadata.Version.emptyVersion) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        VersionHelper.getOriginal(version, sb);
        return sb.toString();
    }

    public static void getOriginal(org.eclipse.equinox.p2.metadata.Version version, StringBuffer sb) {
        if (version == null || version == org.eclipse.equinox.p2.metadata.Version.emptyVersion) {
            return;
        }
        String orig = version.getOriginal();
        if (orig != null) {
            sb.append(orig);
        } else {
            version.toString(sb);
        }
    }

    public static IVersionFormat getOSGiFormat() {
        return sampleOSGiVersion.getFormat();
    }

    public static String getQualifier(org.eclipse.equinox.p2.metadata.Version version) {
        if (version == null || version == org.eclipse.equinox.p2.metadata.Version.emptyVersion || version.getSegmentCount() == 0) {
            return null;
        }
        Comparable last = version.getSegment(version.getSegmentCount() - 1);
        if (!(last instanceof String)) {
            return null;
        }
        String qual = (String)((Object)last);
        return qual.length() > 0 ? qual : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionType getVersionType(IVersionFormat format) {
        if (format == null) {
            try {
                return VersionHelper.getVersionType("Raw Omni Version");
            }
            catch (MissingVersionTypeException e) {
                throw new RuntimeException("Unable to find version type extension for type: Raw Omni Version");
            }
        }
        String fmtString = format.toString();
        fmtString = fmtString.substring(7, fmtString.length() - 1);
        HashMap<String, VersionType> hashMap = knownTypes;
        synchronized (hashMap) {
            VersionType vt = knownTypes.get(fmtString);
            if (vt == null) {
                vt = new VersionType(format, fmtString);
                knownTypes.put(fmtString, vt);
            }
            return vt;
        }
    }

    public static VersionType getVersionType(String id) throws MissingVersionTypeException {
        if (id == null) {
            id = "OSGi";
        }
        for (VersionType vt : knownTypes.values()) {
            String[] stringArray = vt.getLabels();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String label = stringArray[n2];
                if (label.equals(id)) {
                    return vt;
                }
                ++n2;
            }
        }
        throw new MissingVersionTypeException(id);
    }

    public static VersionType getVersionType(org.eclipse.equinox.p2.metadata.Version version) {
        return VersionHelper.getVersionType(version.getFormat());
    }

    public static VersionType getVersionType(VersionRange range) {
        return VersionHelper.getVersionType(range.getFormat());
    }

    public static VersionRange greaterOrEqualRange(org.eclipse.equinox.p2.metadata.Version version) {
        if (version == null) {
            return null;
        }
        if (version == org.eclipse.equinox.p2.metadata.Version.emptyVersion) {
            return VersionRange.emptyRange;
        }
        return new VersionRange(version.toString());
    }

    public static org.eclipse.equinox.p2.metadata.Version parseVersion(String versionStr) {
        org.eclipse.equinox.p2.metadata.Version version;
        try {
            version = org.eclipse.equinox.p2.metadata.Version.parseVersion((String)versionStr);
        }
        catch (IllegalArgumentException e) {
            try {
                version = VersionHelper.createVersion("Triplet", versionStr);
            }
            catch (MissingVersionTypeException e1) {
                throw new IllegalArgumentException(e);
            }
        }
        if (version.equals(org.eclipse.equinox.p2.metadata.Version.emptyVersion)) {
            version = null;
        }
        return version;
    }

    public static org.eclipse.equinox.p2.metadata.Version parseVersionAttributes(Attributes attrs) throws CoreException {
        String tmp = AbstractHandler.getOptionalStringValue((Attributes)attrs, (String)"version");
        if (tmp == null) {
            return null;
        }
        try {
            String type = AbstractHandler.getOptionalStringValue((Attributes)attrs, (String)"versionType");
            return type == null ? VersionHelper.parseVersion(tmp) : VersionHelper.createVersion(type, tmp);
        }
        catch (IllegalArgumentException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public static VersionRange parseVersionRangeAttributes(Attributes attrs) throws CoreException {
        return VersionHelper.parseVersionRangeAttributes(attrs, "versionDesignator", "versionType");
    }

    public static VersionRange parseVersionRangeAttributes(Attributes attrs, String versionAttr, String versionTypeAttr) throws CoreException {
        String tmp = AbstractHandler.getOptionalStringValue((Attributes)attrs, (String)versionAttr);
        if (tmp == null) {
            return null;
        }
        try {
            String type = AbstractHandler.getOptionalStringValue((Attributes)attrs, (String)versionTypeAttr);
            return type == null ? new VersionRange(tmp) : VersionHelper.createRange(type, tmp);
        }
        catch (IllegalArgumentException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public static org.eclipse.equinox.p2.metadata.Version replaceQualifier(org.eclipse.equinox.p2.metadata.Version v, String qualifier) {
        if (v == null) {
            return null;
        }
        String q = VersionHelper.getQualifier(v);
        if (q == null) {
            return v;
        }
        IVersionFormat vf = v.getFormat();
        String vs = v.getOriginal();
        if (vf == null || vs == null || !vs.endsWith(q)) {
            return v;
        }
        int lenWOQ = vs.length() - (q.length() + 1);
        if (lenWOQ <= 0) {
            return v;
        }
        char sep = vs.charAt(lenWOQ);
        vs = vs.substring(0, lenWOQ);
        if (qualifier != null && qualifier.length() > 0) {
            vs = String.valueOf(vs) + sep + qualifier;
        }
        return vf.parse(vs);
    }

    public static Object toTimestampString(Date timestamp) {
        return timestampFormat.format(timestamp);
    }

    public static VersionRange unqualifiedRange(org.eclipse.equinox.p2.metadata.Version v) {
        if (v == null) {
            return null;
        }
        if (v.getSegmentCount() < 2) {
            return null;
        }
        IVersionFormat vf = v.getFormat();
        String str = (v = VersionHelper.replaceQualifier(v, null)).getOriginal();
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return null;
        }
        while (--len >= 0 && Character.isDigit(str.charAt(len))) {
        }
        if (++len >= str.length()) {
            return null;
        }
        Integer lastInt = Integer.valueOf(str.substring(len));
        str = String.valueOf(str.substring(0, len)) + (lastInt + 1);
        return new VersionRange(v, true, vf.parse(str), false);
    }
}

