/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.rmap.maven.impl;

import org.eclipse.buckminster.rmap.Transform;
import org.eclipse.buckminster.rmap.impl.ProviderImpl;
import org.eclipse.buckminster.rmap.maven.GroupAndArtifact;
import org.eclipse.buckminster.rmap.maven.MapEntry;
import org.eclipse.buckminster.rmap.maven.Mappings;
import org.eclipse.buckminster.rmap.maven.MavenPackage;
import org.eclipse.buckminster.rmap.maven.MavenProvider;
import org.eclipse.buckminster.rmap.maven.Scopes;
import org.eclipse.buckminster.rmap.maven.impl.MapEntryImpl;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.osgi.util.NLS;

public class MavenProviderImpl
extends ProviderImpl
implements MavenProvider {
    protected Mappings mappings;
    protected Scopes scopes;
    protected static final boolean TRANSITIVE_EDEFAULT = true;
    protected boolean transitive = true;

    public static MapEntry getDefaultMapEntry(String name) {
        int dotIdx = name.lastIndexOf(47);
        MapEntryImpl entry = new MapEntryImpl();
        entry.setName(name);
        if (dotIdx > 0) {
            entry.setGroupId(name.substring(0, dotIdx));
            entry.setArtifactId(name.substring(dotIdx + 1));
        } else {
            entry.setGroupId(name);
            entry.setArtifactId(name);
        }
        return entry;
    }

    public static String getDefaultName(String groupId, String artifactId) {
        if (groupId.equals(artifactId)) {
            int colonIdx = artifactId.indexOf(58);
            if (colonIdx < 0) {
                return artifactId;
            }
            groupId = artifactId.substring(0, colonIdx);
            artifactId = artifactId.substring(colonIdx + 1);
        }
        return String.valueOf(groupId) + '/' + artifactId;
    }

    protected MavenProviderImpl() {
    }

    public NotificationChain basicSetMappings(Mappings newMappings, NotificationChain msgs) {
        Mappings oldMappings = this.mappings;
        this.mappings = newMappings;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldMappings, (Object)newMappings);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public NotificationChain basicSetScopes(Scopes newScopes, NotificationChain msgs) {
        Scopes oldScopes = this.scopes;
        this.scopes = newScopes;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldScopes, (Object)newScopes);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 14: {
                return this.getMappings();
            }
            case 15: {
                return this.getScopes();
            }
            case 16: {
                return this.isTransitive();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 14: {
                return this.basicSetMappings(null, msgs);
            }
            case 15: {
                return this.basicSetScopes(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 14: {
                return this.mappings != null;
            }
            case 15: {
                return this.scopes != null;
            }
            case 16: {
                return !this.transitive;
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 14: {
                this.setMappings((Mappings)newValue);
                return;
            }
            case 15: {
                this.setScopes((Scopes)newValue);
                return;
            }
            case 16: {
                this.setTransitive((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 14: {
                this.setMappings(null);
                return;
            }
            case 15: {
                this.setScopes(null);
                return;
            }
            case 16: {
                this.setTransitive(true);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public String getComponentName(String groupId, String artifactId) {
        if (this.getMappings() == null) {
            return MavenProviderImpl.getDefaultName(groupId, artifactId);
        }
        for (MapEntry me : this.getMappings().getEntries()) {
            if (me.isMatchFor(groupId, artifactId)) {
                return me.getName();
            }
            EList<GroupAndArtifact> aliases = me.getAliases();
            int idx = aliases.size();
            while (--idx >= 0) {
                GroupAndArtifact alias = (GroupAndArtifact)aliases.get(idx);
                if (!alias.isMatchFor(groupId, artifactId)) continue;
                return me.getName();
            }
        }
        EList<Transform> rules = this.getMappings().getRules();
        if (rules.size() > 0) {
            String compiled = String.valueOf(groupId) + '/' + artifactId;
            for (Transform rule : rules) {
                String transformed = rule.transformTo(compiled);
                if (transformed == null) continue;
                return transformed;
            }
        }
        return MavenProviderImpl.getDefaultName(groupId, artifactId);
    }

    @Override
    public MapEntry getMapEntry(String name) throws CoreException {
        if (this.getMappings() == null) {
            return MavenProviderImpl.getDefaultMapEntry(name);
        }
        for (MapEntry me : this.getMappings().getEntries()) {
            if (!name.equals(me.getName())) continue;
            return me;
        }
        String transformed = null;
        for (Transform rule : this.getMappings().getRules()) {
            transformed = rule.transformFrom(name);
            if (transformed != null) break;
        }
        if (transformed == null) {
            return MavenProviderImpl.getDefaultMapEntry(name);
        }
        int slashPos = transformed.indexOf(47);
        if (slashPos < 0) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)"The result of applying a match rule on ''{0}'' had no separator slash: ''{1}''", (Object)name, (Object)transformed), (Object[])new Object[0]);
        }
        MapEntryImpl me = new MapEntryImpl();
        me.setName(name);
        me.setGroupId(transformed.substring(0, slashPos));
        me.setArtifactId(transformed.substring(slashPos + 1));
        return me;
    }

    @Override
    public Mappings getMappings() {
        return this.mappings;
    }

    @Override
    public Scopes getScopes() {
        return this.scopes;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public void setMappings(Mappings newMappings) {
        if (newMappings != this.mappings) {
            NotificationChain msgs = null;
            if (this.mappings != null) {
                msgs = ((InternalEObject)this.mappings).eInverseRemove((InternalEObject)this, -15, null, msgs);
            }
            if (newMappings != null) {
                msgs = ((InternalEObject)newMappings).eInverseAdd((InternalEObject)this, -15, null, msgs);
            }
            if ((msgs = this.basicSetMappings(newMappings, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)newMappings, (Object)newMappings));
        }
    }

    @Override
    public void setScopes(Scopes newScopes) {
        if (newScopes != this.scopes) {
            NotificationChain msgs = null;
            if (this.scopes != null) {
                msgs = ((InternalEObject)this.scopes).eInverseRemove((InternalEObject)this, -16, null, msgs);
            }
            if (newScopes != null) {
                msgs = ((InternalEObject)newScopes).eInverseAdd((InternalEObject)this, -16, null, msgs);
            }
            if ((msgs = this.basicSetScopes(newScopes, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)newScopes, (Object)newScopes));
        }
    }

    @Override
    public void setTransitive(boolean newTransitive) {
        boolean oldTransitive = this.transitive;
        this.transitive = newTransitive;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, oldTransitive, this.transitive));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (transitive: ");
        result.append(this.transitive);
        result.append(')');
        return result.toString();
    }

    protected EClass eStaticClass() {
        return MavenPackage.Literals.MAVEN_PROVIDER;
    }
}

