/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subversion.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

public class ExceptionExtractor {
    private static final Properties MESSAGES = new Properties();
    private static final Properties TRANSLATIONS = new Properties();
    private static final String COMMENT = "This file is autogenerated from " + ExceptionExtractor.class.getName() + "\n#Please consult it for more informations.\n";
    final String ID;

    static {
        try {
            MESSAGES.load(ExceptionExtractor.class.getResourceAsStream("exception_messages.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void main(String[] args) throws IOException {
        ArrayList<String> versions = new ArrayList<String>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            File[] files;
            String folder = stringArray[n2];
            String folderName = new File(folder).getName();
            String version = folderName.split("-")[1];
            versions.add(version);
            new ExceptionExtractor(version);
            File[] fileArray = files = ExceptionExtractor.gatherPoFiles(new File(String.valueOf(folder) + "/subversion/po"));
            int n3 = files.length;
            int n4 = 0;
            while (n4 < n3) {
                File file = fileArray[n4];
                new ExceptionExtractor(version, file);
                ++n4;
            }
            ++n2;
        }
        StringBuilder builder = new StringBuilder(COMMENT);
        builder.append('\n');
        builder.append("# Message used\n");
        builder.append("# ------------\n");
        for (Object value : MESSAGES.values()) {
            builder.append("# " + value).append('\n');
        }
        builder.append('\n');
        builder.append("# Version used\n");
        builder.append("# ------------\n");
        for (String version : versions) {
            builder.append("# " + version).append('\n');
        }
        builder.append('\n');
        TRANSLATIONS.store(new FileOutputStream("src/org/eclipse/buckminster/subversion/svn_exception_messages.properties"), builder.toString());
    }

    private static File[] gatherPoFiles(File file) {
        if (!file.isDirectory()) {
            return new File[0];
        }
        return file.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".po");
            }
        });
    }

    private static String getLangage(File file) {
        String name = file.getName();
        int indexOf = name.indexOf(".po");
        return name.substring(0, indexOf);
    }

    protected ExceptionExtractor(String version) throws IOException {
        this.ID = version;
        for (Object key : MESSAGES.keySet()) {
            String exceptionKey = (String)key;
            String message = (String)MESSAGES.get(key);
            TRANSLATIONS.put(this.getExceptionName(exceptionKey), this.getLongestTextPart(this.cleanLine(message)));
        }
    }

    protected ExceptionExtractor(String version, File file) throws IOException {
        this.ID = String.valueOf(version) + '|' + ExceptionExtractor.getLangage(file);
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        System.out.println(">> reading " + file.getAbsolutePath());
        try {
            this.processStream(new BufferedReader(reader));
        }
        finally {
            reader.close();
        }
    }

    private String cleanLine(String line) {
        int startIndex = line.indexOf(34);
        int lastIndex = line.lastIndexOf(34);
        return line.substring(startIndex + 1, lastIndex);
    }

    private String getExceptionName(String exception) {
        return String.valueOf(exception) + '|' + this.ID;
    }

    private String getLongestTextPart(String translation) {
        String[] split = translation.split("%ld|%s");
        int maxLenght = 0;
        int maxIndex = 0;
        int i = 0;
        while (i < split.length) {
            if (split[i].length() > maxLenght) {
                maxIndex = i;
                maxLenght = split[i].length();
            }
            ++i;
        }
        return split[maxIndex];
    }

    private String getTranslation(BufferedReader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()).indexOf("msgstr") == -1) {
        }
        do {
            builder.append(this.cleanLine(line));
        } while ((line = reader.readLine()).indexOf(34) != -1);
        return builder.toString();
    }

    private String isExceptionMessage(String line) {
        Set<Object> keySet = MESSAGES.keySet();
        for (Object object : keySet) {
            String exception = (String)object;
            String message = MESSAGES.getProperty(exception);
            if (line.indexOf(message) == -1) continue;
            return exception;
        }
        return null;
    }

    private void processStream(BufferedReader reader) throws IOException {
        String line = null;
        while ((line = reader.readLine()) != null) {
            String exception = this.isExceptionMessage(line);
            if (exception == null) continue;
            TRANSLATIONS.put(this.getExceptionName(exception), this.getLongestTextPart(this.getTranslation(reader)));
        }
    }
}

