/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui;

import org.eclipse.buckminster.ui.Messages;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SplashScreen {
    private final String CLOSE_TEXT = Messages.splashScreen_splash_will_close_after_X_sec_but_you_can_click_to_close;
    private final Shell splashShell;
    private final Label textLabel;

    public SplashScreen(Image image, final int closeTimeout, final boolean closeTextFlag, boolean waitFlag) {
        Display display = Display.getDefault();
        this.splashShell = new Shell(16384);
        this.splashShell.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SplashScreen.this.splashClose();
            }
        });
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.splashShell.setLayout((Layout)gridLayout);
        this.splashShell.setBackground(display.getSystemColor(1));
        this.splashShell.setBackgroundMode(2);
        Label imageLabel = new Label((Composite)this.splashShell, 0);
        imageLabel.setImage(image);
        imageLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SplashScreen.this.splashClose();
            }
        });
        imageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        if (closeTextFlag) {
            Composite textComposite = new Composite((Composite)this.splashShell, 0);
            textComposite.setLayout((Layout)new GridLayout(1, false));
            textComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            this.textLabel = new Label(textComposite, 0);
            this.textLabel.setText(String.format(this.CLOSE_TEXT, closeTimeout));
            this.textLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    SplashScreen.this.splashClose();
                }
            });
        } else {
            this.textLabel = null;
        }
        this.splashShell.pack();
        Rectangle splashRect = this.splashShell.getBounds();
        Rectangle displayRect = display.getBounds();
        int x = (displayRect.width - splashRect.width) / 2;
        int y = (displayRect.height - splashRect.height) / 2;
        this.splashShell.setLocation(x, y);
        this.splashShell.open();
        Thread timer = new Thread(new Runnable(){

            public void run() {
                int i = closeTimeout;
                while (i > 0) {
                    if (SplashScreen.this.splashShell.isDisposed()) {
                        return;
                    }
                    if (closeTextFlag) {
                        SplashScreen.this.displayClosingText(i);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    --i;
                }
                SplashScreen.this.splashClose();
            }
        });
        timer.start();
        if (waitFlag) {
            while (!this.splashShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    private void displayClosingText(final int secToClose) {
        if (this.textLabel == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SplashScreen.this.textLabel.setText(String.format(SplashScreen.this.CLOSE_TEXT, secToClose));
            }
        });
    }

    private void splashClose() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!SplashScreen.this.splashShell.isDisposed()) {
                    SplashScreen.this.splashShell.close();
                    SplashScreen.this.splashShell.dispose();
                }
            }
        });
    }
}

