/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.ui.general.editor.ITable;
import org.eclipse.buckminster.ui.general.editor.ITableModifyListener;
import org.eclipse.buckminster.ui.general.editor.TableModifyEvent;
import org.eclipse.buckminster.ui.general.editor.TableModifyEventType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Table<T>
implements ITable<T> {
    private List<T> data;
    private boolean readOnly;
    private List<ITableModifyListener<T>> listeners = new ArrayList<ITableModifyListener<T>>();

    public Table(List<T> data) {
        this(data, false);
    }

    public Table(List<T> data, boolean readOnly) {
        this.data = data;
        this.readOnly = readOnly;
    }

    @Override
    public void addTableModifyListener(ITableModifyListener<T> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public T getRow(int row) {
        return this.data.get(row);
    }

    @Override
    public List<T> getRows() {
        return this.data;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void removeRow(int row) {
        T oldTableRow = this.data.remove(row);
        this.notifyListeners(TableModifyEventType.REMOVE_ROW, row, oldTableRow);
    }

    @Override
    public void removeTableModifyListener(ITableModifyListener<T> listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners(TableModifyEventType eventType, int row, T tableRow) {
        TableModifyEvent<T> e = new TableModifyEvent<T>(this, eventType, row, tableRow);
        for (ITableModifyListener<T> listener : this.listeners) {
            listener.modifyTable(e);
        }
    }
}

