/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspecext.model.CSpecExtension;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.ctype.IResolutionBuilder;
import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.metadata.builder.ResolutionBuilder;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.ResolvedNode;
import org.eclipse.buckminster.core.parser.IParser;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IFileReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.reader.ZipArchiveReader;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public abstract class AbstractResolutionBuilder
extends AbstractExtension
implements IResolutionBuilder {
    private String nature;
    private int weight = 0;

    public static String getMetadataFile(ICatalogReader reader, String prefName, String defaultPath, IProgressMonitor monitor) throws CoreException {
        return AbstractResolutionBuilder.getMetadataFile(reader.readBuckminsterPreferences(monitor), prefName, defaultPath);
    }

    public static String getMetadataFile(IEclipsePreferences prefs, String prefName, String defaultPath) {
        String metadataFolder;
        if (prefs == null) {
            return defaultPath;
        }
        IPath path = Path.fromPortableString((String)(defaultPath = prefs.get(prefName, defaultPath)));
        if (!path.isAbsolute() && (metadataFolder = prefs.get(IComponentType.PREF_METADATA_FOLDER, null)) != null) {
            path = Path.fromPortableString((String)metadataFolder).append(path);
        }
        return path.makeRelative().toPortableString();
    }

    public int compareTo(IResolutionBuilder o) {
        int ow = o.getWeight();
        return this.weight > ow ? 1 : (this.weight == ow ? 0 : -1);
    }

    public ResolvedNode createNode(IComponentReader reader, CSpecBuilder cspecBuilder) throws CoreException {
        return new ResolvedNode(reader.getNodeQuery(), this.createResolution(reader, cspecBuilder));
    }

    public String getComponentTypeID() {
        return null;
    }

    public String getNature() {
        return this.nature;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String tmp = config.getAttribute("weight");
        if (tmp != null) {
            this.weight = Integer.parseInt(tmp);
        }
        this.nature = config.getAttribute("nature");
        super.setInitializationData(config, propertyName, data);
    }

    protected void applyExtensions(CSpecBuilder cspecBuilder, boolean forResolutionAidOnly, IComponentReader reader, IProgressMonitor monitor) throws CoreException {
        if (!(reader instanceof ICatalogReader)) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return;
        }
        ICatalogReader catReader = (ICatalogReader)reader;
        try {
            CSpecExtension cspecExt = catReader.readFile("buckminster.cspex", new IStreamConsumer<CSpecExtension>(){

                @Override
                public CSpecExtension consumeStream(IComponentReader rdr, String streamName, InputStream stream, IProgressMonitor mon) throws CoreException {
                    mon.beginTask(null, 1);
                    mon.subTask(streamName);
                    try {
                        IParser<CSpecExtension> cspecExtParser = CorePlugin.getDefault().getParserFactory().getAlterCSpecParser(true);
                        CSpecExtension ce = cspecExtParser.parse(streamName, stream);
                        MonitorUtils.worked((IProgressMonitor)mon, (int)1);
                        CSpecExtension cSpecExtension = ce;
                        return cSpecExtension;
                    }
                    finally {
                        mon.done();
                    }
                }
            }, monitor);
            if (forResolutionAidOnly) {
                cspecExt.alterTopElement(cspecBuilder);
            } else {
                cspecExt.alterCSpec(cspecBuilder);
            }
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    protected Resolution createResolution(IComponentReader reader, CSpecBuilder cspecBuilder) throws CoreException {
        return this.createResolution(reader, cspecBuilder, false);
    }

    protected Resolution createResolution(IComponentReader reader, CSpecBuilder cspecBuilder, boolean unpack) throws CoreException {
        ResolutionBuilder resBld = reader.getProviderMatch().createResolution(cspecBuilder, unpack);
        resBld.setMaterializable(reader.canMaterialize());
        if (reader instanceof ZipArchiveReader) {
            reader = ((ZipArchiveReader)reader).getFileReader();
        }
        if (reader instanceof IFileReader) {
            resBld.setFileInfo(((IFileReader)reader).getFileInfo());
        }
        return new Resolution(resBld);
    }
}

