/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.sax;

import org.eclipse.buckminster.sax.ISaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractSaxableElement
implements ISaxableElement,
IAdaptable {
    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void toSax(ContentHandler handler, String namespace, String prefix, String localName) throws SAXException {
        String qName = Utils.makeQualifiedName(prefix, localName);
        AttributesImpl attrs = new AttributesImpl();
        this.addAttributes(attrs);
        handler.startElement(namespace, localName, qName, attrs);
        this.emitElements(handler, this.getElementNamespace(namespace), this.getElementPrefix(prefix));
        handler.endElement(namespace, localName, qName);
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
    }

    protected String getElementNamespace(String namespace) throws SAXException {
        return namespace;
    }

    protected String getElementPrefix(String prefix) throws SAXException {
        return prefix;
    }
}

