/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subversive.internal;

import java.io.File;
import java.util.Date;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.subversion.GenericReaderType;
import org.eclipse.buckminster.subversion.ISubversionSession;
import org.eclipse.buckminster.subversive.Messages;
import org.eclipse.buckminster.subversive.internal.SubversiveRemoteFileReader;
import org.eclipse.buckminster.subversive.internal.SubversiveSession;
import org.eclipse.buckminster.subversive.internal.SubversiveVersionFinder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.SVNTeamProjectMapper;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubversiveReaderType
extends GenericReaderType<IRepositoryLocation, SVNEntry, SVNRevision> {
    private static SVNChangeStatus getLocalInfo(File workingCopy, IProgressMonitor monitor) {
        IPath checkedPath;
        IPath location = Path.fromOSString((String)workingCopy.toString());
        IPath iPath = checkedPath = workingCopy.isFile() ? location.removeLastSegments(1) : location;
        if (!checkedPath.append(SVNUtility.getSVNFolderName()).toFile().exists()) {
            return null;
        }
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().createConnector();
        try {
            SVNChangeStatus[] st = SVNUtility.status((ISVNConnector)proxy, (String)location.toString(), (int)2, (long)128L, (ISVNProgressMonitor)new SVNNullProgressMonitor());
            if (st == null || st.length == 0) {
                return null;
            }
            SVNUtility.reorder((SVNChangeStatus[])st, (boolean)true);
            SVNChangeStatus sVNChangeStatus = st[0];
            return sVNChangeStatus;
        }
        catch (Exception ex) {
            return null;
        }
        finally {
            proxy.dispose();
            MonitorUtils.complete((IProgressMonitor)monitor);
        }
    }

    protected IRepositoryLocation[] getKnownRepositories(IProgressMonitor monitor) {
        IRepositoryLocation[] repos = SVNRemoteStorage.instance().getRepositoryLocations();
        MonitorUtils.complete((IProgressMonitor)monitor);
        return repos;
    }

    public Date getLastModification(File workingCopy, IProgressMonitor monitor) throws CoreException {
        SVNChangeStatus localInfo = SubversiveReaderType.getLocalInfo(workingCopy, monitor);
        return localInfo == null ? null : new Date(localInfo.lastChangedDate);
    }

    public long getLastRevision(File workingCopy, IProgressMonitor monitor) throws CoreException {
        SVNChangeStatus localInfo = SubversiveReaderType.getLocalInfo(workingCopy, monitor);
        return localInfo == null ? -1L : localInfo.lastChangedRevision;
    }

    public IComponentReader getReader(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        return new SubversiveRemoteFileReader((IReaderType)this, providerMatch, monitor);
    }

    public String getRemoteLocation(File workingCopy, IProgressMonitor monitor) throws CoreException {
        SVNEntryInfo info = SVNUtility.getSVNInfo((File)workingCopy);
        MonitorUtils.complete((IProgressMonitor)monitor);
        return info == null ? null : info.url;
    }

    protected ISubversionSession<SVNEntry, SVNRevision> getSession(String repositoryURI, VersionSelector branchOrTag, long revision, Date timestamp, RMContext context) throws CoreException {
        return new SubversiveSession(repositoryURI, branchOrTag, revision, timestamp, context);
    }

    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery nodeQuery, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new SubversiveVersionFinder(provider, ctype, nodeQuery);
    }

    protected void updateRepositoryMap(IProject project, ISubversionSession<SVNEntry, SVNRevision> session) throws Exception {
        IRepositoryLocation location = (IRepositoryLocation)((SubversiveSession)session).getRepositoryLocation();
        IRepositoryContainer resource = null;
        resource = location.asRepositoryContainer(session.getSVNUrl().toString(), true);
        if (resource == null) {
            throw BuckminsterException.fromMessage((String)Messages.could_not_create_repository_resource, (Object[])new Object[0]);
        }
        SVNTeamProjectMapper.map((IProject)project, (IRepositoryResource)resource);
    }
}

