/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.actions;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.ui.ComboInputDialog;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiPlugin;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.ExternalFileEditorInput;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class OpenQueryAction
implements IWorkbenchWindowActionDelegate {
    private static final String LAST_CQUERY_URL = "lastCQueryURL";
    private static final String LAST_CQUERY_URLS = "lastCQueryURLs";
    private static final int MAX_REMEMBERED_CQUERIES = 5;
    private IWorkbenchWindow workbenchWindow;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.workbenchWindow = window;
    }

    public void run(IAction action) {
        IPreferenceStore preferences = UiPlugin.getDefault().getPreferenceStore();
        Shell shell = this.workbenchWindow.getShell();
        String lastURLsString = preferences.getString(LAST_CQUERY_URLS);
        String[] lastURLs = null;
        if (lastURLsString != null && lastURLsString.length() > 0) {
            lastURLs = lastURLsString.split(";");
        } else {
            String lastURLString = preferences.getString(LAST_CQUERY_URL);
            if (lastURLString != null) {
                lastURLs = new String[]{lastURLString};
            }
        }
        ComboInputDialog askURL = new ComboInputDialog(shell, null, Messages.url_for_query_with_colon, lastURLs, lastURLs.length > 0 ? lastURLs[0] : null, new URLValidator());
        if (askURL.open() != 0) {
            return;
        }
        String urlStr = askURL.getValue();
        if (urlStr == null) {
            return;
        }
        if ((urlStr = urlStr.trim()).length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(urlStr);
        int cnt = 1;
        String[] stringArray = lastURLs;
        int n = lastURLs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (cnt >= 5) break;
            if (!urlStr.equals(str)) {
                sb.append(';');
                sb.append(str);
                ++cnt;
            }
            ++n2;
        }
        preferences.setValue(LAST_CQUERY_URLS, sb.toString());
        try {
            URL url = URLUtils.normalizeToURL((String)urlStr);
            File cqueryFile = FileUtils.getFile((URL)url);
            if (cqueryFile == null) {
                File tempFile = File.createTempFile("bmqtmp-", ".cquery");
                tempFile.deleteOnExit();
                FileOutputStream output = null;
                try {
                    output = new FileOutputStream(tempFile);
                    DownloadManager.readInto((URL)url, null, (OutputStream)output, null);
                }
                catch (Throwable throwable) {
                    IOUtils.close(output);
                    throw throwable;
                }
                IOUtils.close((Closeable)output);
                cqueryFile = tempFile;
            }
            IWorkbench workbench = PlatformUI.getWorkbench();
            IEditorDescriptor ed = workbench.getEditorRegistry().getDefaultEditor("buckminster.cquery");
            this.workbenchWindow.getActivePage().openEditor((IEditorInput)new ExternalFileEditorInput(cqueryFile, new Path(url.toURI().getPath()).lastSegment(), urlStr), ed.getId());
        }
        catch (Exception e) {
            UiUtils.openError(shell, Messages.unable_to_open_editor, e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private static class URLValidator
    implements IInputValidator {
        private URLValidator() {
        }

        public String isValid(String newText) {
            if (newText != null && (newText = newText.trim()).length() > 0) {
                try {
                    new URL(newText);
                    return null;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return Messages.please_enter_a_valid_url;
        }
    }
}

