/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cmdline.parser;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.Logger;

public class CommandLineParser
implements Iterator<String> {
    private final StringBuffer innerBld = new StringBuffer();
    private final StringBuffer outerBld = new StringBuffer();
    private final String line;
    private String nextToken;
    private int pos;

    private static char getEscapedChar(char escaped) {
        switch (escaped) {
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
        }
        return escaped;
    }

    public CommandLineParser(String line) {
        this.line = line;
        int top = line.length();
        while (this.pos < top) {
            char c = line.charAt(this.pos);
            if (Character.isWhitespace(c)) {
                ++this.pos;
                continue;
            }
            if (c != '#') break;
            this.pos = top;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextToken == null) {
            this.nextToken = this.nextToken();
        }
        return this.nextToken != null;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String nxt = this.nextToken;
        this.nextToken = null;
        return nxt;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void getExpanded(StringBuffer bld, String string) {
        Logger logger = Buckminster.getLogger();
        int top = string.length();
        int idx = 0;
        while (idx < top) {
            int end;
            int start;
            char c;
            if ((c = string.charAt(idx++)) != '$') {
                bld.append(c);
                continue;
            }
            if (idx == top) break;
            c = string.charAt(idx);
            if (c == '{') {
                start = ++idx;
                while (idx < top && string.charAt(idx) != '}') {
                    ++idx;
                }
                end = idx++;
            } else {
                start = idx;
                while (idx < top && Character.isJavaIdentifierPart(string.charAt(idx))) {
                    ++idx;
                }
                end = idx;
            }
            if (end <= start) continue;
            String key = string.substring(start, end);
            String value = key.length() > 4 && "env:".equalsIgnoreCase(string.substring(0, 4)) ? System.getenv(key.substring(4)) : System.getProperty(key);
            logger.debug("key '%s' expanded to '%s'", new Object[]{key, value});
            if (value == null) continue;
            bld.append(value);
        }
    }

    private String getQuoted(char quote) {
        this.innerBld.setLength(0);
        int top = this.line.length();
        while (this.pos < top) {
            char c;
            if ((c = this.line.charAt(this.pos++)) == quote) break;
            if (c == '\\') {
                if (this.pos == top) break;
                c = CommandLineParser.getEscapedChar(this.line.charAt(this.pos++));
            }
            this.innerBld.append(c);
        }
        return this.innerBld.toString();
    }

    private String getSpaceDelimited() {
        this.innerBld.setLength(0);
        int top = this.line.length();
        while (this.pos < top) {
            char c = this.line.charAt(this.pos);
            if (Character.isWhitespace(c) || c == '\'' || c == '\"') break;
            ++this.pos;
            if (c == '\\' && (this.pos == top || !Character.isWhitespace(c = this.line.charAt(this.pos++)) && Character.isWhitespace(c = CommandLineParser.getEscapedChar(c)))) break;
            this.innerBld.append(c);
        }
        return this.innerBld.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String nextToken() {
        this.outerBld.setLength(0);
        top = this.line.length();
        if (this.pos != top) ** GOTO lbl24
        return null;
lbl-1000:
        // 1 sources

        {
            c = this.line.charAt(this.pos);
            switch (c) {
                case '\'': {
                    ++this.pos;
                    this.outerBld.append(this.getQuoted('\''));
                    break;
                }
                case '\"': {
                    ++this.pos;
                    this.getExpanded(this.outerBld, this.getQuoted('\"'));
                    break;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        ++this.pos;
                        while (this.pos < top && Character.isWhitespace(this.line.charAt(this.pos))) {
                            ++this.pos;
                        }
                        break block4;
                    }
                    this.getExpanded(this.outerBld, this.getSpaceDelimited());
                }
            }
lbl24:
            // 4 sources

            ** while (this.pos < top)
        }
lbl25:
        // 2 sources

        return this.outerBld.toString();
    }
}

