/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cmdline.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.cmdline.Messages;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.parser.AmbiguousOptionException;
import org.eclipse.buckminster.cmdline.parser.InvalidOptionException;
import org.eclipse.buckminster.cmdline.parser.NoOptionNameException;
import org.eclipse.buckminster.cmdline.parser.OptionRequiresValueException;

public class ParseResult {
    private static final String DASH = "-";
    private static final String DOUBLEDASH = "--";
    private final Option[] options;
    private final String[] unparsed;

    public static ParseResult parse(String[] args, List<OptionDescriptor> optionDescriptors) throws NoOptionNameException, AmbiguousOptionException, InvalidOptionException, OptionRequiresValueException {
        ArrayList<Option> options = new ArrayList<Option>();
        int max = args.length;
        int i = 0;
        while (i < max) {
            String arg = args[i].trim();
            if (arg.equals(DOUBLEDASH)) {
                ++i;
                break;
            }
            if (!arg.startsWith(DASH)) break;
            if (arg.length() == 1) {
                throw new NoOptionNameException();
            }
            if (!arg.equals("-pdelaunch")) {
                if (arg.equals("-launcher")) {
                    ++i;
                } else if (arg.equals("-name")) {
                    i += 2;
                } else {
                    boolean isLongName = arg.startsWith(DOUBLEDASH);
                    String argName = arg.substring(1 + (isLongName ? 1 : 0));
                    String optionValue = null;
                    if (!isLongName && argName.length() > 1) {
                        optionValue = argName.substring(1);
                        argName = argName.substring(0, 1);
                    }
                    OptionDescriptor descriptorToUse = null;
                    int top = optionDescriptors.size();
                    int idx = 0;
                    while (idx < top) {
                        OptionDescriptor descriptor = optionDescriptors.get(idx);
                        if (descriptor.isAcceptableName(argName, isLongName, true)) {
                            descriptorToUse = descriptor;
                            break;
                        }
                        if (isLongName && descriptor.isAcceptableName(argName, isLongName, false)) {
                            if (descriptorToUse != null) {
                                throw new AmbiguousOptionException(arg);
                            }
                            descriptorToUse = descriptor;
                        }
                        ++idx;
                    }
                    if (descriptorToUse == null) {
                        throw new InvalidOptionException(arg);
                    }
                    if (optionValue != null) {
                        if (descriptorToUse.getType() == 1) {
                            throw new InvalidOptionException(arg);
                        }
                    } else if (descriptorToUse.getType() != 1) {
                        if (descriptorToUse.getType() == 2) {
                            String s;
                            if (i + 1 < max && !(s = args[i + 1]).startsWith(DASH)) {
                                ++i;
                                optionValue = s;
                            }
                        } else if (descriptorToUse.getType() == 3) {
                            if (i + 1 == max) {
                                throw new OptionRequiresValueException(arg);
                            }
                            optionValue = args[++i];
                        } else {
                            throw new InternalError(Messages.ParseResult_Unknown_OptionValueType);
                        }
                    }
                    options.add(new Option(descriptorToUse, argName, optionValue, isLongName));
                }
            }
            ++i;
        }
        String[] unparsed = new String[max - i];
        System.arraycopy(args, i, unparsed, 0, unparsed.length);
        return new ParseResult(options.toArray(new Option[options.size()]), unparsed);
    }

    private ParseResult(Option[] options, String[] unparsed) {
        this.options = options;
        this.unparsed = unparsed;
    }

    public Option[] getOptions() {
        return this.options;
    }

    public String[] getUnparsed() {
        return this.unparsed;
    }
}

