/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.build;

import java.lang.reflect.Method;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.build.PropertiesEmitter;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.ModelCache;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class LocationEmitter
extends PropertiesEmitter {
    public static final String ARG_PURPOSE = "purpose";
    public static final String ARG_FORMAT_LOCATION = "format.location";
    public static final String ARG_FORMAT_ARTIFACTS = "format.artifacts";
    public static final Format FORMAT_LOCATION = new MessageFormat("bm.location.{0}");
    public static final Format FORMAT_LOCATION_ARTIFACT = new MessageFormat("bm.artifacts.{0}.{1}");
    private static boolean stateKnown = false;
    private static Method getDefaultOutputFolder;

    public static IPath getDefaultOutputFolder(IProject project) throws CoreException {
        if (!LocationEmitter.isJDTPresent()) {
            return null;
        }
        try {
            return (IPath)getDefaultOutputFolder.invoke(null, project);
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public static synchronized boolean isJDTPresent() {
        if (!stateKnown) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.buckminster.jdt");
            if (bundle == null) {
                stateKnown = true;
                return false;
            }
            try {
                Class classpathEmitterClass = bundle.loadClass("org.eclipse.buckminster.jdt.internal.ClasspathEmitter");
                getDefaultOutputFolder = classpathEmitterClass.getMethod("getDefaultOutputFolder", IProject.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stateKnown = true;
        }
        return getDefaultOutputFolder != null;
    }

    @Override
    protected void addFormatters() {
        this.addFormat(ARG_FORMAT_LOCATION, FORMAT_LOCATION);
        this.addFormat(ARG_FORMAT_ARTIFACTS, FORMAT_LOCATION_ARTIFACT);
    }

    @Override
    protected void appendProperties() throws CoreException {
        try {
            ModelCache cache = new ModelCache();
            CSpec cspec = WorkspaceInfo.getCSpec((IResource)this.getProject());
            String attr = this.getArgument(ARG_PURPOSE);
            Set<String> attrs = attr == null ? Collections.emptySet() : Collections.singleton(attr);
            this.appendComponentProperties(cspec, attrs, cache, new HashSet<ComponentIdentifier>());
        }
        catch (MissingComponentException missingComponentException) {
            // empty catch block
        }
    }

    private void appendComponentProperties(CSpec cspec, Set<String> attributes, IModelCache cache, HashSet<ComponentIdentifier> seenIds) throws CoreException {
        ComponentIdentifier cid = cspec.getComponentIdentifier();
        if (seenIds.contains(cid)) {
            return;
        }
        IPath location = cspec.getComponentLocation();
        String componentName = cspec.getName();
        if (location.toFile().isFile()) {
            this.addProperty(ARG_FORMAT_LOCATION, new String[]{componentName}, this.formatPath(location.removeLastSegments(1)));
            this.addProperty(ARG_FORMAT_ARTIFACTS, new String[]{componentName, "default"}, location.lastSegment());
        } else {
            IPath dfltOutput;
            IProject project = WorkspaceInfo.getProject(cid);
            if (project != null && (dfltOutput = LocationEmitter.getDefaultOutputFolder(project)) != null) {
                this.addProperty(ARG_FORMAT_ARTIFACTS, new String[]{componentName, "default"}, dfltOutput.toOSString());
            }
            this.addProperty(ARG_FORMAT_LOCATION, new String[]{componentName}, this.formatPath(location));
        }
        cspec = cspec.prune(null, RMContext.getGlobalPropertyAdditions(), false, attributes);
        for (QualifiedDependency dep : cspec.getQualifiedDependencies(false)) {
            CSpec childSpec = cache.findCSpec(cspec, dep.getRequest());
            this.appendComponentProperties(childSpec, dep.getAttributeNames(), cache, seenIds);
        }
    }
}

