/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.net.URL;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.materializer.MaterializationJob;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.mspec.builder.MaterializationSpecBuilder;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.MainResolver;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.osgi.util.NLS;

public class GetConfiguration
extends WorkspaceCommand {
    private URL url;
    private IConnectContext connectContext;

    protected void handleUnparsed(String[] unparsed) throws Exception {
        int len = unparsed.length;
        if (len > 1) {
            throw new UsageException(Messages.Too_many_arguments);
        }
        if (len == 1) {
            this.url = URLUtils.normalizeToURL((String)unparsed[0]);
        }
    }

    @Override
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        System.out.println(NLS.bind((String)Messages.Using_workspace_at_0, (Object)Platform.getInstanceLocation().getURL().toString()));
        monitor.beginTask(null, 3);
        try {
            ComponentQuery query = ComponentQuery.fromURL(this.url, this.connectContext, true);
            MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
            ResolutionContext context = new ResolutionContext(query);
            MainResolver resolver = new MainResolver(context);
            BillOfMaterials bom = resolver.resolve(query.getExpandedRootRequest(context), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            IStatus status = context.getStatus();
            switch (status.getSeverity()) {
                case 4: {
                    throw new CoreException(status);
                }
                case 2: {
                    System.err.print(NLS.bind((String)Messages.GetConfiguration_Warning, (Object)status.getMessage()));
                    break;
                }
                case 1: {
                    System.out.print(status.getMessage());
                }
            }
            MaterializationSpecBuilder mspecBuilder = new MaterializationSpecBuilder();
            mspecBuilder.setName(bom.getViewName());
            bom.addMaterializationNodes(mspecBuilder);
            MaterializationContext matCtx = new MaterializationContext(bom, mspecBuilder.createMaterializationSpec(), context);
            MaterializationJob.run(matCtx);
            if (matCtx.getStatus().getSeverity() == 4) {
                return 1;
            }
            try {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                System.out.println(Messages.Query_complete);
            }
            catch (Throwable t) {
                CoreException be = BuckminsterException.wrap((Throwable)t);
                if (be.getCause() instanceof SSLHandshakeException) {
                    System.err.println(Messages.SSL_handshake_exception);
                }
                throw be;
            }
        }
        finally {
            monitor.done();
        }
        return 0;
    }
}

