/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.commands.SetPreference;
import org.eclipse.buckminster.core.commands.WorkspaceInitCommand;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.helpers.AccessibleByteArrayOutputStream;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.materializer.MaterializationJob;
import org.eclipse.buckminster.core.mspec.builder.MaterializationSpecBuilder;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.MainResolver;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;

public class Import
extends WorkspaceInitCommand {
    private static final OptionDescriptor BOM_FILE = new OptionDescriptor('B', "bomfile", 3);
    private static final OptionDescriptor NO_IMPORT = new OptionDescriptor('N', "noimport", 1);
    private File bomFile;
    private boolean resolveOnly;
    private URL url;
    private IConnectContext connectContext;

    public void setBomFile(File bomFile) {
        this.bomFile = bomFile;
    }

    public void setConnectContext(IConnectContext cctx) {
        this.connectContext = cctx;
    }

    public void setResolveOnly(boolean flag) {
        this.resolveOnly = flag;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    @Override
    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        super.getOptionDescriptors(appendHere);
        appendHere.add(NO_IMPORT);
        appendHere.add(BOM_FILE);
    }

    @Override
    protected void handleOption(Option option) throws Exception {
        if (option.is(NO_IMPORT)) {
            this.setResolveOnly(true);
        } else if (option.is(BOM_FILE)) {
            this.setBomFile(new File(option.getValue()));
        } else {
            super.handleOption(option);
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        int len = unparsed.length;
        if (len > 1) {
            throw new UsageException(Messages.Too_many_arguments);
        }
        if (len < 1) {
            throw new UsageException(Messages.Missing_BOM_URL);
        }
        this.setURL(URLUtils.normalizeToURL((String)unparsed[0]));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int internalRun(boolean continueOnError, IProgressMonitor monitor) throws Exception {
        block21: {
            block20: {
                logger = Buckminster.getLogger();
                MonitorUtils.begin((IProgressMonitor)monitor, (int)100);
                bomOut = null;
                pf = CorePlugin.getDefault().getParserFactory();
                resolvedURL = FileLocator.resolve((URL)this.url);
                byteBld = new AccessibleByteArrayOutputStream();
                DownloadManager.readInto((URL)resolvedURL, (IConnectContext)this.connectContext, (OutputStream)byteBld, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                if (this.bomFile != null) {
                    bomOut = new BufferedOutputStream(new FileOutputStream(this.bomFile));
                }
                try {
                    mspec = pf.getMaterializationSpecParser(true).parse(resolvedURL.toString(), byteBld.getInputStream());
                }
                catch (CoreException e) {
                    mspec = null;
                }
                MonitorUtils.worked((IProgressMonitor)monitor, (int)5);
                newTpLocation = null;
                if (mspec != null) {
                    resolvedURL = mspec.getResolvedURL();
                    byteBld.reset();
                    DownloadManager.readInto((URL)resolvedURL, (IConnectContext)this.connectContext, (OutputStream)byteBld, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                    newTpLocation = mspec.getInstallLocation();
                } else {
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)20);
                }
                try {
                    cquery = ComponentQuery.fromStream(resolvedURL, this.connectContext, byteBld.getInputStream(), true);
                }
                catch (CoreException e) {
                    cquery = null;
                }
                MonitorUtils.worked((IProgressMonitor)monitor, (int)5);
                if (newTpLocation != null) {
                    SetPreference.set("targetPlatformPath", ExpandingProperties.expand(RMContext.getGlobalPropertyAdditions(), newTpLocation.toPortableString(), 0));
                }
                if (cquery == null) break block20;
                ctx = mspec == null ? new ResolutionContext(cquery) : new ResolutionContext(mspec, cquery);
                resolver = new MainResolver(ctx);
                resolver.getContext().setContinueOnError(true);
                bom = resolver.resolve(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                {
                    catch (Throwable var15_17) {
                        IOUtils.close(bomOut);
                        MonitorUtils.done((IProgressMonitor)monitor);
                        throw var15_17;
                    }
                }
            }
            bom = pf.getBillOfMaterialsParser(true).parse(resolvedURL.toString(), byteBld.getInputStream());
            MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
            while (true) {
                if (bomOut != null) {
                    Utils.serialize((ISaxable)bom, (OutputStream)bomOut);
                    IOUtils.close((Closeable)bomOut);
                    bomOut = null;
                }
                if (!this.resolveOnly) ** GOTO lbl-1000
                IOUtils.close((Closeable)bomOut);
                MonitorUtils.done((IProgressMonitor)monitor);
                return 0;
lbl-1000:
                // 1 sources

                {
                    if (mspec == null) {
                        mspecBld = new MaterializationSpecBuilder();
                        mspecBld.setURL(resolvedURL.toString());
                        mspecBld.setName(bom.getViewName());
                        mspecBld.setMaterializerID(this.getMaterializer());
                        bom.addMaterializationNodes(mspecBld);
                        mspec = mspecBld.createMaterializationSpec();
                    }
                    matCtx = new MaterializationContext(bom, mspec);
                    matCtx.setContinueOnError(continueOnError);
                    MaterializationJob.run(matCtx);
                    ** if (matCtx.getStatus().getSeverity() != 4) goto lbl-1000
                }
lbl-1000:
                // 1 sources

                {
                    IOUtils.close((Closeable)bomOut);
                    MonitorUtils.done((IProgressMonitor)monitor);
                    return 1;
                }
lbl-1000:
                // 1 sources

                {
                    break block21;
                }
                break;
            }
            finally {
                if (!ctx.emitWarningAndErrorTags() || continueOnError) ** continue;
            }
            IOUtils.close((Closeable)bomOut);
            MonitorUtils.done((IProgressMonitor)monitor);
            return 1;
        }
        IOUtils.close((Closeable)bomOut);
        MonitorUtils.done((IProgressMonitor)monitor);
        logger.info(Messages.Import_complete, new Object[0]);
        return 0;
    }
}

