/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.buckminster.core.cspec.IArtifact;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.MissingPathException;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.Artifact;
import org.eclipse.buckminster.core.cspec.model.PathAlreadyDefinedException;
import org.eclipse.core.runtime.IPath;

public class ArtifactBuilder
extends TopLevelAttributeBuilder
implements IArtifact {
    private IPath base;
    private final HashSet<IPath> paths = new HashSet();

    ArtifactBuilder(CSpecBuilder cspecBuilder) {
        super(cspecBuilder);
    }

    public void addPath(IPath path) throws PathAlreadyDefinedException {
        if (this.paths.contains(path)) {
            throw new PathAlreadyDefinedException(this.getCSpecName(), this.getName(), path);
        }
        this.paths.add(path);
    }

    @Override
    public void clear() {
        super.clear();
        this.base = null;
        this.paths.clear();
    }

    @Override
    public Artifact createAttribute() {
        return new Artifact(this);
    }

    @Override
    public AttributeBuilder getAttributeBuilder(CSpecBuilder specBuilder) {
        return specBuilder == this.getCSpecBuilder() ? this : new ArtifactBuilder(specBuilder);
    }

    @Override
    public IPath getBase() {
        return this.base;
    }

    @Override
    public Set<IPath> getPaths() {
        return this.paths;
    }

    @Override
    public void initFrom(IAttribute attribute) {
        super.initFrom(attribute);
        IArtifact artifact = (IArtifact)attribute;
        this.base = artifact.getBase();
        this.paths.addAll(artifact.getPaths());
    }

    public void removePath(IPath path) throws MissingPathException {
        if (!this.paths.contains(path)) {
            throw new MissingPathException(this.getCSpecName(), this.getName(), path);
        }
        this.paths.remove(path);
    }

    public void setBase(IPath base) {
        this.base = base == null ? null : base.addTrailingSeparator();
    }
}

