/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecElementBuilder;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.Generator;
import org.eclipse.equinox.p2.metadata.Version;

public class GeneratorBuilder
extends CSpecElementBuilder
implements IGenerator {
    private String attribute;
    private String component;
    private String generatesType;
    private Version generatesVersion;

    GeneratorBuilder(CSpecBuilder cspecBuilder) {
        super(cspecBuilder);
    }

    @Override
    public void clear() {
        super.clear();
        this.component = null;
        this.attribute = null;
        this.generatesType = null;
        this.generatesVersion = null;
    }

    public Generator createGenerator(CSpec cspec) {
        return new Generator(cspec, this.component, this.attribute, this.getGeneratedIdentifier());
    }

    @Override
    public String getAttribute() {
        return this.attribute;
    }

    @Override
    public String getComponent() {
        return this.component;
    }

    @Override
    public ComponentIdentifier getGeneratedIdentifier() {
        return new ComponentIdentifier(this.getName(), this.generatesType, this.generatesVersion);
    }

    public String getGenerates() {
        return this.getName();
    }

    public void initFrom(IGenerator generator) {
        IComponentIdentifier ci = generator.getGeneratedIdentifier();
        super.initFrom(ci.getName());
        this.component = generator.getComponent();
        this.attribute = generator.getAttribute();
        this.generatesType = ci.getComponentTypeID();
        this.generatesVersion = ci.getVersion();
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public void setGeneratesType(String generatesType) {
        this.generatesType = generatesType;
    }

    public void setGeneratesVersion(Version version) {
        this.generatesVersion = version;
    }
}

