/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspecext.parser;

import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.parser.AttributeHandler;
import org.eclipse.buckminster.core.cspec.parser.GroupHandler;
import org.eclipse.buckminster.core.cspec.parser.PrerequisiteHandler;
import org.eclipse.buckminster.core.cspecext.builder.AlterAttributeBuilder;
import org.eclipse.buckminster.core.cspecext.builder.AlterGroupBuilder;
import org.eclipse.buckminster.core.cspecext.parser.AlterAttributeHandler;
import org.eclipse.buckminster.core.cspecext.parser.RemoveHandler;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class AlterGroupHandler
extends AlterAttributeHandler {
    private final RemoveHandler removeHandler = new RemoveHandler((AbstractHandler)this, "remove", "name");
    private final PrerequisiteHandler alterHandler = new PrerequisiteHandler((AbstractHandler)this);

    AlterGroupHandler(AbstractHandler parent, AttributeHandler baseHandler) {
        super(parent, baseHandler);
    }

    AlterGroupHandler(AbstractHandler parent, boolean publ) {
        super(parent, new GroupHandler(parent, publ));
    }

    @Override
    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.removeHandler) {
            this.addRemovePrerequisite(this.removeHandler.getValue());
        } else if (child == this.alterHandler) {
            try {
                this.addAlterPrerequisite(((PrerequisiteBuilder)this.alterHandler.getBuilder()).createPrerequisite());
            }
            catch (PrerequisiteAlreadyDefinedException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
            }
        } else {
            super.childPopped(child);
        }
    }

    @Override
    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ExtensionAwareHandler ch = this.removeHandler.getTAG().equals(localName) ? this.removeHandler : ("alterAttribute".equals(localName) ? this.alterHandler : super.createHandler(uri, localName, attrs));
        return ch;
    }

    void addAlterPrerequisite(Prerequisite prereq) throws PrerequisiteAlreadyDefinedException {
        ((AlterGroupBuilder)this.getBuilder()).addAlterPrerequisite(prereq);
    }

    void addRemovePrerequisite(String key) {
        ((AlterGroupBuilder)this.getBuilder()).addRemovePrerequisite(key);
    }

    @Override
    AlterAttributeBuilder createAlterAttributeBuilder(AttributeBuilder baseBuilder) {
        return new AlterGroupBuilder((GroupBuilder)baseBuilder);
    }
}

