/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;

public class JobBlocker
extends JobChangeAdapter {
    private final Set<String> blockByName = Collections.synchronizedSet(new HashSet());
    private final Set<String> blockByClass = Collections.synchronizedSet(new HashSet());

    private static void trace(String format, Object ... args) {
    }

    public JobBlocker() {
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this);
    }

    public void aboutToRun(IJobChangeEvent event) {
        Job job = event.getJob();
        String jobName = job.getName();
        String className = job.getClass().getName();
        JobBlocker.trace(NLS.bind((String)Messages.JOB_AboutToRun_0, (Object)jobName), new Object[0]);
        if (this.blockByName.contains(jobName) || this.blockByClass.contains(className)) {
            job.cancel();
            JobBlocker.trace(NLS.bind((String)Messages.Blocked_0_1, (Object)className, (Object)jobName), new Object[0]);
            return;
        }
    }

    public void addClassBlock(Class<? extends Job> classToBlock) {
        this.blockByClass.add(classToBlock.getName());
    }

    public void addClassBlock(String className) {
        this.blockByClass.add(className);
    }

    public void addNameBlock(String nameToBlock) {
        this.blockByName.add(nameToBlock);
    }

    public void release() {
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
    }

    public void removeClassBlock(Class<? extends Job> classToBlock) {
        this.blockByClass.remove(classToBlock.getName());
    }

    public void removeClassBlock(String className) {
        this.blockByClass.remove(className);
    }

    public void removeNameBlock(String nameToBlock) {
        this.blockByName.remove(nameToBlock);
    }
}

