/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.actor.IPerformManager;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.TopLevelAttribute;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.materializer.ExternalDataArea;
import org.eclipse.buckminster.core.materializer.FileSystemMaterializer;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.materializer.ProjectNameMismatchException;
import org.eclipse.buckminster.core.metadata.ModelCache;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.WorkspaceBinding;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.reader.CatalogReaderType;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.LocalReaderType;
import org.eclipse.buckminster.core.reader.P2ReaderType;
import org.eclipse.buckminster.core.resolver.LocalResolver;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

public class WorkspaceMaterializer
extends FileSystemMaterializer {
    private static Materialization getMaterialization(Resolution resolution) throws CoreException {
        Materialization mat = WorkspaceInfo.getMaterialization(resolution);
        if (mat != null) {
            return mat;
        }
        String readerTypeName = resolution.getProvider().getReaderTypeId();
        if (!"local".equals(readerTypeName)) {
            return null;
        }
        IReaderType localReaderType = CorePlugin.getDefault().getReaderType(readerTypeName);
        return new Materialization(localReaderType.getFixedLocation(resolution), resolution.getComponentIdentifier());
    }

    private static boolean isSegmentPrefix(IPath self, IPath other) {
        String[] otherSegments;
        String device = self.getDevice();
        if (device != null && other.getDevice() != null && !device.equalsIgnoreCase(other.getDevice())) {
            return false;
        }
        if (self.isEmpty() || self.isRoot() && other.isAbsolute()) {
            return true;
        }
        String[] segments = self.segments();
        int len = segments.length;
        if (len > (otherSegments = other.segments()).length) {
            return false;
        }
        if (FileUtils.CASE_INSENSITIVE_FS) {
            int i = 0;
            while (i < len) {
                if (!segments[i].equalsIgnoreCase(otherSegments[i])) {
                    return false;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                if (!segments[i].equals(otherSegments[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static void storeBelow(Resolution resolution, BOMNode node, StorageManager sm, boolean isBelow) throws CoreException {
        String readerType;
        Resolution nodeRes = node.getResolution();
        if (nodeRes == null) {
            return;
        }
        if (!isBelow) {
            isBelow = nodeRes.equals(resolution);
        }
        if (isBelow && !"eclipse.platform".equals(readerType = resolution.getProvider().getReaderTypeId())) {
            resolution.store(sm);
            Materialization mat = WorkspaceMaterializer.getMaterialization(resolution);
            if (mat != null) {
                mat.store(sm);
            }
        }
        for (BOMNode child : node.getChildren()) {
            WorkspaceMaterializer.storeBelow(resolution, child, sm, isBelow);
        }
    }

    private WorkspaceBinding createBindSpec(Resolution resolution, MaterializationContext context) throws CoreException {
        IPath wsRelativePath;
        Materialization mat = WorkspaceMaterializer.getMaterialization(resolution);
        if (mat == null) {
            return null;
        }
        IPath wsRoot = context.getWorkspaceLocation(resolution);
        IPath matLoc = mat.getComponentLocation();
        IPath bmProjLoc = CorePlugin.getDefault().getBuckminsterProjectLocation();
        if (matLoc.hasTrailingSeparator() && !bmProjLoc.isPrefixOf(matLoc)) {
            wsRelativePath = context.getMaterializationSpec().getResourcePath(resolution);
            if (wsRelativePath == null) {
                wsRelativePath = Path.fromPortableString((String)this.getDefaultProjectName(context.getMaterializationSpec(), resolution));
            }
        } else {
            IPath localWsRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            if (!FileUtils.pathEquals(wsRoot, localWsRoot) && localWsRoot.isPrefixOf(bmProjLoc)) {
                bmProjLoc = wsRoot.append(bmProjLoc.removeFirstSegments(localWsRoot.segmentCount()));
            }
            wsRelativePath = bmProjLoc.isPrefixOf(matLoc) ? matLoc.removeFirstSegments(bmProjLoc.segmentCount() - 1).setDevice(null) : new Path(".buckminster").append(matLoc.lastSegment());
            if (matLoc.hasTrailingSeparator()) {
                wsRelativePath = wsRelativePath.addTrailingSeparator();
            }
        }
        return new WorkspaceBinding(matLoc, resolution, wsRoot, wsRelativePath, context.getBindingProperties());
    }

    private void createExternalBinding(IPath wsRelativePath, WorkspaceBinding mat, IProgressMonitor monitor) throws CoreException, IOException {
        IPath locationPath = mat.getComponentLocation();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsRoot = workspace.getRoot();
        monitor.beginTask(null, 200);
        monitor.subTask(NLS.bind((String)Messages.Binding_0, (Object)locationPath));
        try {
            IProject projectForBinding;
            String projName = wsRelativePath.segment(0);
            IPath projRelativePath = wsRelativePath.removeFirstSegments(1);
            IPath locationProjRoot = null;
            int relSegs = projRelativePath.segmentCount();
            int matSegs = locationPath.segmentCount();
            if (matSegs >= relSegs && locationPath.removeFirstSegments(matSegs - relSegs).setDevice(null).equals((Object)projRelativePath)) {
                locationProjRoot = locationPath.removeLastSegments(relSegs);
            }
            boolean useLink = false;
            if (locationProjRoot == null) {
                if (relSegs == 1) {
                    useLink = true;
                } else {
                    throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Unable_to_determine_project_root_when_binding_0_to_workspace_1, (Object)locationPath, (Object)wsRelativePath), (Object[])new Object[0]);
                }
            }
            if (!(projectForBinding = wsRoot.getProject(projName)).exists()) {
                if (useLink || FileUtils.pathEquals(locationProjRoot.removeLastSegments(1), wsRoot.getLocation())) {
                    projectForBinding.create(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                } else {
                    IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(projName);
                    desc.setLocation(locationProjRoot);
                    projectForBinding.create(desc, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                }
                projectForBinding.open(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            } else if (!projectForBinding.isOpen()) {
                projectForBinding.open(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            } else {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)100);
            }
            if (useLink) {
                if (locationPath.toFile().isDirectory()) {
                    IFolder folder = projectForBinding.getFolder(projRelativePath);
                    if (folder.exists()) {
                        if (!folder.isLinked() || !FileUtils.pathEquals(folder.getRawLocation(), locationPath)) {
                            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Unable_to_create_folder_link_from_workspace_0_to_1_2_already_in_use, (Object[])new Object[]{wsRelativePath, locationPath, projRelativePath}), (Object[])new Object[0]);
                        }
                        MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
                    } else {
                        folder.createLink(locationPath, 0, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                    }
                } else {
                    IFile ifile = projectForBinding.getFile(projRelativePath);
                    if (ifile.exists()) {
                        if (!ifile.isLinked() || !FileUtils.pathEquals(ifile.getRawLocation(), locationPath)) {
                            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Unable_to_create_file_link_from_workspace_0_to_1_link_origin_2_already_in_use, (Object[])new Object[]{wsRelativePath, locationPath, projRelativePath}), (Object[])new Object[0]);
                        }
                        MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
                    } else {
                        ifile.createLink(locationPath, 0, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                    }
                }
            } else {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
            }
            projectForBinding.refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            IResource resource = projectForBinding.findMember(projRelativePath);
            if (resource == null) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Unable_to_obtain_resource_0_from_workspace_1, (Object)wsRelativePath, (Object)projRelativePath), (Object[])new Object[0]);
            }
            WorkspaceInfo.setComponentIdentifier(projectForBinding.findMember(projRelativePath), mat.getComponentIdentifier());
        }
        finally {
            monitor.done();
        }
    }

    private void createProjectBinding(String suggestedProjectName, WorkspaceBinding wb, RMContext context, IProgressMonitor monitor) throws CoreException, IOException {
        IProjectDescription description;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsRoot = workspace.getRoot();
        IPath locationPath = wb.getComponentLocation();
        if (!locationPath.toFile().exists()) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            throw new FileNotFoundException(locationPath.toString());
        }
        monitor.beginTask(null, 150);
        monitor.subTask(NLS.bind((String)Messages.Binding_0, (Object)suggestedProjectName));
        try {
            description = workspace.loadProjectDescription(locationPath.append(".project"));
            suggestedProjectName = description.getName();
        }
        catch (CoreException e) {
            description = null;
        }
        MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
        IPath wsRootPath = wsRoot.getLocation();
        boolean isRootedInWorkspace = wsRootPath.segmentCount() == locationPath.segmentCount() - 1 && WorkspaceMaterializer.isSegmentPrefix(wsRootPath, locationPath);
        try {
            RepositoryProvider provider;
            IProject project;
            if (description == null) {
                if (isRootedInWorkspace) {
                    String forcedName = locationPath.lastSegment();
                    if (!forcedName.equals(suggestedProjectName)) {
                        throw new ProjectNameMismatchException(suggestedProjectName, forcedName);
                    }
                    description = workspace.newProjectDescription(suggestedProjectName);
                } else {
                    description = workspace.newProjectDescription(suggestedProjectName);
                    description.setLocation(locationPath);
                }
            }
            if (!(project = wsRoot.getProject(suggestedProjectName)).isOpen()) {
                if (!project.exists()) {
                    IProject describedProject = wsRoot.getProject(description.getName());
                    if (describedProject.exists()) {
                        URI describedLocation = describedProject.getLocationURI();
                        if (describedLocation.equals(description.getLocationURI())) {
                            Buckminster.getLogger().warning(NLS.bind((String)"Name of project {0} conflicts with previously bound name {1}", (Object)suggestedProjectName, (Object)description.getName()), new Object[0]);
                            project = describedProject;
                            MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
                        } else {
                            Buckminster.getLogger().warning(NLS.bind((String)"Name of project {0} conflicts with name {1} found in .project file.", (Object)suggestedProjectName, (Object)description.getName()), new Object[0]);
                            description.setName(suggestedProjectName);
                            project.create(description, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                        }
                    } else {
                        project.create(description, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                    }
                }
                project.open(0, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
            }
            if ((provider = RepositoryProvider.getProvider((IProject)project)) != null) {
                return;
            }
            Resolution cr = wb.getResolution(StorageManager.getDefault());
            IReaderType readerType = this.getMaterializationReaderType(cr);
            if (readerType instanceof LocalReaderType) {
                IReaderType scmReaderType = null;
                try {
                    IPath location = project.getLocation();
                    while (location.segmentCount() > 0) {
                        IPath dotGit = location.append(".git");
                        if (dotGit.toFile().isDirectory()) {
                            Buckminster.getLogger().debug("Project %s has a git repository at %s", new Object[]{project.getName(), location.toPortableString()});
                            scmReaderType = CorePlugin.getDefault().getReaderType("git");
                            break;
                        }
                        location = location.removeLastSegments(1);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (scmReaderType == null && project.getFolder(".svn").exists()) {
                    try {
                        scmReaderType = CorePlugin.getDefault().getReaderType("svn");
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                if (scmReaderType == null && project.getFolder("CVS").exists()) {
                    try {
                        scmReaderType = CorePlugin.getDefault().getReaderType("cvs");
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                if (scmReaderType == null) {
                    Buckminster.getLogger().debug("Unable to determine readerType for project %s. Assuming \"local\"", new Object[]{project.getName()});
                } else {
                    readerType = scmReaderType;
                }
            }
            readerType.shareProject(project, cr, context, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            WorkspaceInfo.setComponentIdentifier((IResource)project, cr.getCSpec().getComponentIdentifier());
            MonitorUtils.worked((IProgressMonitor)monitor, (int)30);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected IPath getArtifactLocation(MaterializationContext context, Resolution resolution) throws CoreException {
        IReaderType readerType;
        IPath installLocation = context.getInstallLocation(resolution);
        IPath leafArtifact = context.getLeafArtifact(resolution);
        installLocation = leafArtifact == null ? installLocation.addTrailingSeparator() : ("eclipse.import".equals((readerType = this.getMaterializationReaderType(resolution)).getId()) ? installLocation.append(resolution.getName()).addTrailingSeparator() : installLocation.append(leafArtifact));
        return installLocation;
    }

    @Override
    public IPath getDefaultInstallRoot(MaterializationContext context, Resolution resolution) throws CoreException {
        IReaderType readerType;
        IPath location = context.getWorkspaceLocation(resolution);
        IPath leaf = context.getLeafArtifact(resolution);
        if (leaf == null) {
            if (context.getMaterializationSpec().isUnpack(resolution)) {
                location = location.append(".buckminster");
            }
        } else if (!leaf.hasTrailingSeparator() && !"eclipse.import".equals((readerType = this.getMaterializationReaderType(resolution)).getId())) {
            location = location.append(".buckminster");
        }
        return location;
    }

    private String getDefaultProjectName(MaterializationSpec mspec, Resolution resolution) throws CoreException {
        return mspec.getProjectName(resolution);
    }

    @Override
    public IReaderType getMaterializationReaderType(Resolution resolution) throws CoreException {
        IReaderType rt = super.getMaterializationReaderType(resolution);
        if (rt instanceof P2ReaderType) {
            rt = CorePlugin.getDefault().getReaderType("eclipse.import");
        }
        if (rt instanceof CatalogReaderType) {
            return rt;
        }
        String ctId = resolution.getComponentTypeId();
        if ("osgi.bundle".equals(ctId) || "eclipse.feature".equals(ctId)) {
            rt = CorePlugin.getDefault().getReaderType("eclipse.import");
        }
        return rt;
    }

    public void installLocal(WorkspaceBinding wb, RMContext context, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 200);
        try {
            try {
                StorageManager sm = StorageManager.getDefault();
                monitor.subTask(NLS.bind((String)Messages.Binding_0, (Object)wb.getWorkspaceRelativePath()));
                Materialization mat = wb.getMaterialization();
                mat.store(sm);
                MonitorUtils.worked((IProgressMonitor)monitor, (int)10);
                wb = this.performPrebindAction(wb, context, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)95));
                IProgressMonitor subMonitor = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)95);
                IPath wsRelativePath = wb.getWorkspaceRelativePath();
                if (wsRelativePath.segmentCount() == 1) {
                    this.createProjectBinding(wsRelativePath.segment(0), wb, context, subMonitor);
                } else {
                    this.createExternalBinding(wsRelativePath, wb, subMonitor);
                }
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void performInstallAction(Resolution resolution, MaterializationContext context, IProgressMonitor monitor) throws CoreException {
        try {
            WorkspaceBinding wb = this.createBindSpec(resolution, context);
            if (wb == null) {
                MonitorUtils.complete((IProgressMonitor)monitor);
                return;
            }
            IPath wsRoot = wb.getWorkspaceRoot();
            if (FileUtils.pathEquals(wsRoot, ResourcesPlugin.getWorkspace().getRoot().getLocation())) {
                this.installLocal(wb, context, monitor);
            } else {
                ExternalDataArea dataArea = new ExternalDataArea(wsRoot, context.getMaterializationSpec().getConflictResolution(resolution));
                StorageManager sm = new StorageManager(dataArea.getStateLocation(CorePlugin.getID()).toFile());
                wb.store(sm);
                WorkspaceMaterializer.storeBelow(resolution, context.getBillOfMaterials(), sm, false);
            }
        }
        catch (CoreException e) {
            if (!context.isContinueOnError()) {
                throw e;
            }
            context.addRequestStatus(resolution.getRequest(), e.getStatus());
        }
    }

    @Override
    public void performPostInstallAction(Resolution resolution, MaterializationContext context, IProgressMonitor monitor) throws CoreException {
        CSpec cspec = resolution.getCSpec();
        Attribute postbindAttr = cspec.getPostbind();
        if (postbindAttr != null) {
            try {
                CorePlugin.getPerformManager().perform(cspec, postbindAttr.getName(), context, false, false, monitor);
            }
            catch (CoreException e) {
                if (!context.isContinueOnError()) {
                    throw e;
                }
                context.addRequestStatus(resolution.getRequest(), e.getStatus());
            }
        }
    }

    private WorkspaceBinding performPrebindAction(WorkspaceBinding wb, RMContext context, IProgressMonitor monitor) throws CoreException {
        StorageManager sm = StorageManager.getDefault();
        Resolution resolution = wb.getResolution(StorageManager.getDefault());
        CSpec cspec = resolution.getCSpec();
        try {
            IPerformManager performManager = CorePlugin.getPerformManager();
            Attribute bindEntryPoint = cspec.getBindEntryPoint();
            if (!(bindEntryPoint instanceof TopLevelAttribute)) {
                Attribute prebindAttr = cspec.getPrebind();
                if (prebindAttr != null) {
                    performManager.perform(cspec, prebindAttr.getName(), context, false, false, monitor);
                } else {
                    MonitorUtils.complete((IProgressMonitor)monitor);
                }
                return wb;
            }
            Map<String, ? extends Object> props = context.getProperties(resolution.getRequest());
            IPath productPath = ((TopLevelAttribute)bindEntryPoint).getUniquePath(wb.getComponentLocation(), new ModelCache(props));
            String bindingName = context.getBindingName(resolution, props);
            performManager.perform(cspec, bindEntryPoint.getName(), props, false, false, monitor);
            Resolution newRes = LocalResolver.fromPath(productPath, resolution.getName());
            newRes = new Resolution(newRes.getCSpec(), resolution);
            newRes.store(sm);
            Materialization newMat = new Materialization(productPath.addTrailingSeparator(), newRes.getComponentIdentifier());
            newMat.store(sm);
            return new WorkspaceBinding(newMat.getComponentLocation(), newRes, wb.getWorkspaceRoot(), (IPath)new Path(bindingName), null);
        }
        catch (CoreException e) {
            if (!context.isContinueOnError()) {
                throw e;
            }
            context.addRequestStatus(resolution.getRequest(), e.getStatus());
            return wb;
        }
    }
}

