/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.model;

import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.SAXEmitter;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WorkspaceBinding
extends Materialization
implements Comparable<WorkspaceBinding> {
    public static final int SEQUENCE_NUMBER = 1;
    public static final String TAG = "workspaceBinding";
    public static final String ATTR_WS_RELATIVE_PATH = "workspaceRelativePath";
    public static final String ATTR_WS_LOCATION = "workspaceLocation";
    public static final String ATTR_TIMESTAMP = "timestamp";
    public static final String ATTR_RESOLUTION_ID = "resolutionId";
    private final long timestamp;
    private final IPath workspaceRoot;
    private final IPath workspaceRelativePath;
    private final Map<String, String> properties;
    private final UUID resolutionId;
    private static long lastTS = System.currentTimeMillis();

    public static long getNextTimestamp() {
        long now = System.currentTimeMillis();
        if (now > lastTS) {
            lastTS = now;
        } else {
            now = ++lastTS;
        }
        return now;
    }

    public WorkspaceBinding(IPath componentLocation, ComponentIdentifier cid, UUID resId, IPath workspaceRoot, IPath workspaceRelativePath, Map<String, String> properties, long timestamp) {
        super(componentLocation, cid);
        this.resolutionId = resId;
        this.timestamp = timestamp;
        this.workspaceRoot = workspaceRoot;
        this.workspaceRelativePath = workspaceRelativePath;
        this.properties = ExpandingProperties.createUnmodifiableProperties(properties);
    }

    public WorkspaceBinding(IPath componentLocation, Resolution res, IPath workspaceRoot, IPath workspaceRelativePath, Map<String, String> properties) {
        this(componentLocation, res.getComponentIdentifier(), res.getId(), workspaceRoot, workspaceRelativePath, properties, WorkspaceBinding.getNextTimestamp());
    }

    @Override
    public int compareTo(WorkspaceBinding o) {
        return this.timestamp < o.timestamp ? -1 : (this.timestamp == o.timestamp ? 0 : 1);
    }

    @Override
    public String getDefaultTag() {
        return TAG;
    }

    public Materialization getMaterialization() {
        return new Materialization(this.getComponentLocation(), this.getComponentIdentifier());
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Resolution getResolution(StorageManager sm) throws CoreException {
        return sm.getResolutions().getElement(this.resolutionId);
    }

    public IPath getWorkspaceRelativePath() {
        return this.workspaceRelativePath;
    }

    public IPath getWorkspaceRoot() {
        return this.workspaceRoot;
    }

    @Override
    public boolean isPersisted(StorageManager sm) throws CoreException {
        return sm.getWorkspaceBindings().contains(this);
    }

    @Override
    public void remove(StorageManager sm) throws CoreException {
        sm.getWorkspaceBindings().removeElement(this.getId());
    }

    @Override
    public void store(StorageManager sm) throws CoreException {
        sm.getWorkspaceBindings().putElement(this);
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        super.addAttributes(attrs);
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_WS_RELATIVE_PATH, (String)this.workspaceRelativePath.toPortableString());
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_WS_LOCATION, (String)this.workspaceRoot.toPortableString());
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TIMESTAMP, (String)Long.toString(this.timestamp));
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_RESOLUTION_ID, (String)this.resolutionId.toString());
    }

    protected void emitElements(ContentHandler receiver, String namespace, String prefix) throws SAXException {
        super.emitElements(receiver, namespace, prefix);
        SAXEmitter.emitProperties(receiver, this.properties, namespace, prefix, true, false);
    }
}

