/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.mspec.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.core.mspec.IMaterializationDirective;
import org.eclipse.core.runtime.IPath;

public abstract class MaterializationDirectiveBuilder
implements IMaterializationDirective {
    private Documentation documentation;
    private IPath installLocation;
    private IPath workspaceLocation;
    private String materializerID;
    private final HashMap<String, String> properties = new HashMap();
    private ConflictResolution conflictResolution;
    private int maxParallelJobs = -1;

    public void clear() {
        this.maxParallelJobs = -1;
        this.installLocation = null;
        this.workspaceLocation = null;
        this.materializerID = null;
        this.conflictResolution = null;
        this.documentation = null;
        this.properties.clear();
    }

    @Override
    public ConflictResolution getConflictResolution() {
        return this.conflictResolution;
    }

    @Override
    public Documentation getDocumentation() {
        return this.documentation;
    }

    @Override
    public IPath getInstallLocation() {
        return this.installLocation;
    }

    @Override
    public String getMaterializerID() {
        return this.materializerID;
    }

    @Override
    public int getMaxParallelJobs() {
        return this.maxParallelJobs;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public IPath getWorkspaceLocation() {
        return this.workspaceLocation;
    }

    public void initFrom(IMaterializationDirective md) {
        this.clear();
        this.documentation = md.getDocumentation();
        this.installLocation = md.getInstallLocation();
        this.workspaceLocation = md.getWorkspaceLocation();
        this.materializerID = md.getMaterializerID();
        this.maxParallelJobs = md.getMaxParallelJobs();
        this.conflictResolution = md.getConflictResolution();
        this.properties.putAll(md.getProperties());
    }

    public void setConflictResolution(ConflictResolution conflictResolution) {
        this.conflictResolution = conflictResolution;
    }

    public void setDocumentation(Documentation documentation) {
        this.documentation = documentation;
    }

    public void setInstallLocation(IPath installLocation) {
        this.installLocation = installLocation;
    }

    public void setMaterializerID(String materializerID) {
        this.materializerID = materializerID;
    }

    public void setMaxParallelJobs(int maxParallelJobs) {
        this.maxParallelJobs = maxParallelJobs;
    }

    public void setWorkspaceLocation(IPath workspaceLocation) {
        this.workspaceLocation = workspaceLocation;
    }
}

