/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.query.builder;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.query.IAdvisorNode;
import org.eclipse.buckminster.core.query.model.AdvisorNode;
import org.eclipse.buckminster.core.query.model.MutableLevel;
import org.eclipse.buckminster.core.query.model.SourceLevel;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.p2.metadata.VersionRange;

public class AdvisorNodeBuilder
implements IAdvisorNode {
    private boolean allowCircularDependency;
    private final ArrayList<String> attributes = new ArrayList();
    private VersionSelector[] branchTagPath;
    private String componentType;
    private Documentation documentation;
    private Filter filter;
    private MutableLevel mutableLevel;
    private Pattern namePattern;
    private URL overlayFolder;
    private Map<String, String> properties;
    private boolean prune;
    private int[] resolutionPrio;
    private String revision;
    private boolean skipComponent;
    private SourceLevel sourceLevel;
    private boolean systemDiscovery;
    private Date timestamp;
    private boolean useTargetPlatform;
    private boolean useMaterialization;
    private boolean useWorkspace;
    private boolean useRemoteResolution;
    private VersionRange versionOverride;

    public AdvisorNodeBuilder() {
        this.clear();
    }

    public void addAttribute(String attribute) {
        this.attributes.add(attribute);
    }

    public void addAttributes(List<String> attrs) {
        this.attributes.addAll(attrs);
    }

    @Override
    public boolean allowCircularDependency() {
        return this.allowCircularDependency;
    }

    public void clear() {
        this.attributes.clear();
        this.properties = null;
        this.documentation = null;
        this.componentType = null;
        this.filter = null;
        this.mutableLevel = MutableLevel.INDIFFERENT;
        this.namePattern = null;
        this.overlayFolder = null;
        this.prune = false;
        this.skipComponent = false;
        this.allowCircularDependency = false;
        this.sourceLevel = SourceLevel.INDIFFERENT;
        this.useTargetPlatform = true;
        this.useMaterialization = true;
        this.useWorkspace = true;
        this.versionOverride = null;
        this.useRemoteResolution = true;
        this.systemDiscovery = true;
        this.branchTagPath = VersionSelector.EMPTY_PATH;
        this.revision = null;
        this.timestamp = null;
        this.resolutionPrio = IAdvisorNode.DEFAULT_RESOLUTION_PRIO;
    }

    public AdvisorNode create() {
        return new AdvisorNode(this);
    }

    @Override
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public VersionSelector[] getBranchTagPath() {
        return this.branchTagPath;
    }

    @Override
    public String getComponentTypeID() {
        return this.componentType;
    }

    @Override
    public Documentation getDocumentation() {
        return this.documentation;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    public IPath getMaterializationLocation(String projectName) {
        return null;
    }

    @Override
    public MutableLevel getMutableLevel() {
        return this.mutableLevel;
    }

    @Override
    public Pattern getNamePattern() {
        return this.namePattern;
    }

    @Override
    public URL getOverlayFolder() {
        return this.overlayFolder;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    @Override
    public int[] getResolutionPrio() {
        return this.resolutionPrio;
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    @Override
    public SourceLevel getSourceLevel() {
        return this.sourceLevel;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public VersionRange getVersionOverride() {
        return this.versionOverride;
    }

    public void initFrom(IAdvisorNode node) {
        this.clear();
        this.allowCircularDependency = node.allowCircularDependency();
        this.attributes.addAll(node.getAttributes());
        this.componentType = node.getComponentTypeID();
        this.documentation = node.getDocumentation();
        this.filter = node.getFilter();
        this.mutableLevel = node.getMutableLevel();
        this.namePattern = node.getNamePattern();
        this.overlayFolder = node.getOverlayFolder();
        Map<String, String> props = node.getProperties();
        if (props.size() > 0) {
            this.properties = new HashMap<String, String>(props);
        }
        this.prune = node.isPrune();
        this.skipComponent = node.skipComponent();
        this.sourceLevel = node.getSourceLevel();
        this.useMaterialization = node.isUseMaterialization();
        this.useRemoteResolution = node.isUseRemoteResolution();
        this.useTargetPlatform = node.isUseTargetPlatform();
        this.useWorkspace = node.isUseWorkspace();
        this.versionOverride = node.getVersionOverride();
        this.systemDiscovery = node.isSystemDiscovery();
        this.branchTagPath = node.getBranchTagPath();
        this.revision = node.getRevision();
        this.timestamp = node.getTimestamp();
        this.resolutionPrio = node.getResolutionPrio();
    }

    @Override
    public boolean isPrune() {
        return this.prune;
    }

    @Override
    public boolean isSystemDiscovery() {
        return this.systemDiscovery;
    }

    @Override
    public boolean isUseMaterialization() {
        return this.useMaterialization;
    }

    @Override
    public boolean isUseRemoteResolution() {
        return this.useRemoteResolution;
    }

    @Override
    public boolean isUseTargetPlatform() {
        return this.useTargetPlatform;
    }

    @Override
    public boolean isUseWorkspace() {
        return this.useWorkspace;
    }

    public void setAllowCircularDependency(boolean allowCircularDependency) {
        this.allowCircularDependency = allowCircularDependency;
    }

    public void setBranchTagPath(VersionSelector[] branchTagPath) {
        this.branchTagPath = branchTagPath == null ? VersionSelector.EMPTY_PATH : branchTagPath;
    }

    public void setComponentTypeID(String componentType) {
        this.componentType = componentType;
    }

    public void setDocumentation(Documentation documentation) {
        this.documentation = documentation;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setMutableLevel(MutableLevel mutableLevel) {
        this.mutableLevel = mutableLevel == null ? MutableLevel.INDIFFERENT : mutableLevel;
    }

    public void setNamePattern(Pattern namePattern) {
        this.namePattern = namePattern;
    }

    public void setOverlayFolder(URL addOnFolder) {
        this.overlayFolder = addOnFolder;
    }

    public void setPrune(boolean prune) {
        this.prune = prune;
    }

    public void setResolutionPrio(int[] resolutionPrio) {
        this.resolutionPrio = resolutionPrio;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setSkipComponent(boolean flag) {
        this.skipComponent = flag;
    }

    public void setSourceLevel(SourceLevel sourceLevel) {
        this.sourceLevel = sourceLevel == null ? SourceLevel.INDIFFERENT : sourceLevel;
    }

    public void setSystemDiscovery(boolean flag) {
        this.systemDiscovery = flag;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void setUseMaterialization(boolean flag) {
        this.useMaterialization = flag;
    }

    public void setUseRemoteResolution(boolean flag) {
        this.useRemoteResolution = flag;
    }

    public void setUseTargetPlatform(boolean flag) {
        this.useTargetPlatform = flag;
    }

    public void setUseWorkspace(boolean flag) {
        this.useWorkspace = flag;
    }

    public void setVersionOverride(VersionRange versionOverride) {
        this.versionOverride = versionOverride;
    }

    @Override
    public boolean skipComponent() {
        return this.skipComponent;
    }
}

